/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.test.rule.ClassTestRule;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.junit.runner.Description;

public class DestinationAwaitClassTestRule
extends ClassTestRule<Set<CountDownLatch>> {
    public static final DestinationAwaitClassTestRule INSTANCE = new DestinationAwaitClassTestRule("liferay/document_library_sync_event_processor", "liferay/hot_deploy");
    private final String[] _destinationNames;

    public DestinationAwaitClassTestRule(String ... destinationNames) {
        this._destinationNames = destinationNames;
    }

    @Override
    public void afterClass(Description description, Set<CountDownLatch> endCountDownLatches) throws Throwable {
        endCountDownLatches.forEach(CountDownLatch::countDown);
    }

    @Override
    public Set<CountDownLatch> beforeClass(Description description) throws InterruptedException {
        HashSet<CountDownLatch> endCountdownLatches = new HashSet<CountDownLatch>();
        for (String destinationName : this._destinationNames) {
            final Destination destination = MessageBusUtil.getDestination(destinationName);
            final CountDownLatch startCountDownLatch = new CountDownLatch(1);
            final CountDownLatch endCountDownLatch = new CountDownLatch(1);
            final Message countDownMessage = new Message();
            destination.register(new MessageListener(){

                @Override
                public void receive(Message message) {
                    if (countDownMessage == message) {
                        startCountDownLatch.countDown();
                        try {
                            endCountDownLatch.await();
                            destination.unregister(this);
                        }
                        catch (InterruptedException ie) {
                            ReflectionUtil.throwException(ie);
                        }
                    }
                }
            });
            destination.send(countDownMessage);
            startCountDownLatch.await();
            endCountdownLatches.add(endCountDownLatch);
        }
        return endCountdownLatches;
    }
}

