/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.log;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class CaptureAppender
extends AppenderSkeleton
implements Closeable {
    private static final Field _parentField;
    private final Level _level;
    private final Logger _logger;
    private final List<LoggingEvent> _loggingEvents = new CopyOnWriteArrayList<LoggingEvent>();
    private final Category _parentCategory;

    public CaptureAppender(Logger logger) {
        this._logger = logger;
        this._level = this._logger.getLevel();
        this._parentCategory = logger.getParent();
        try {
            _parentField.set(this._logger, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this._logger.removeAppender((Appender)this);
        this._logger.setLevel(this._level);
        try {
            _parentField.set(this._logger, this._parentCategory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<LoggingEvent> getLoggingEvents() {
        return this._loggingEvents;
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent loggingEvent) {
        this._loggingEvents.add(new PrintableLoggingEvent(loggingEvent));
    }

    static {
        try {
            _parentField = ReflectionUtil.getDeclaredField(Category.class, "parent");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class PrintableLoggingEvent
    extends LoggingEvent {
        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{level=");
            sb.append(this.getLevel());
            sb.append(", message=");
            sb.append(this.getMessage());
            sb.append("}");
            return sb.toString();
        }

        private PrintableLoggingEvent(LoggingEvent loggingEvent) {
            super(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), loggingEvent.getLevel(), loggingEvent.getMessage(), loggingEvent.getThreadName(), loggingEvent.getThrowableInformation(), loggingEvent.getNDC(), loggingEvent.getLocationInformation(), loggingEvent.getProperties());
        }
    }
}

