/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import java.util.Collections;
import java.util.Map;
import javax.portlet.ReadOnlyException;

public class TemplatePortletPreferences {
    private static final Log _log = LogFactoryUtil.getLog(TemplatePortletPreferences.class);
    private final ThreadLocal<PortletPreferencesImpl> _portletPreferencesImplThreadLocal = new CentralizedThreadLocal<PortletPreferencesImpl>(TemplatePortletPreferences.class.getName(), PortletPreferencesImpl::new);

    public String getPreferences(Map<String, Object> preferences) throws ReadOnlyException {
        StringBundler sb = new StringBundler();
        sb.append("<portlet-preferences>");
        for (Map.Entry<String, Object> entry : preferences.entrySet()) {
            sb.append("<preference><name>");
            sb.append(entry.getKey());
            sb.append("</name>");
            Object valueObject = entry.getValue();
            if (valueObject instanceof String) {
                sb.append("<value>");
                sb.append(XMLUtil.toCompactSafe((String)valueObject));
                sb.append("</value>");
            } else if (valueObject instanceof String[]) {
                for (String value : (String[])valueObject) {
                    sb.append("<value>");
                    sb.append(XMLUtil.toCompactSafe(value));
                    sb.append("</value>");
                }
            } else {
                sb.setIndex(sb.index() - 3);
                continue;
            }
            sb.append("</preference>");
        }
        sb.append("</portlet-preferences>");
        return sb.toString();
    }

    public String getPreferences(String key, String value) throws ReadOnlyException {
        return this.getPreferences(Collections.singletonMap(key, value));
    }

    public String toString() {
        PortletPreferencesImpl portletPreferencesImpl = this._portletPreferencesImplThreadLocal.get();
        try {
            return PortletPreferencesFactoryUtil.toXML(portletPreferencesImpl);
        }
        catch (Exception e) {
            _log.error(e, e);
            return "<portlet-preferences />";
        }
    }
}

