/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.template.TemplateResourceParser;
import com.liferay.portal.template.URLResourceParser;
import java.net.URL;

@OSGiBeanProperties(property={"lang.type=ftl", "lang.type=soy", "lang.type=vm"}, service={TemplateResourceParser.class})
public class ClassLoaderResourceParser
extends URLResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(ClassLoaderResourceParser.class);
    private final ClassLoader _classLoader;

    public ClassLoaderResourceParser() {
        Class<?> clazz = this.getClass();
        this._classLoader = clazz.getClassLoader();
    }

    @Override
    public URL getURL(String templateId) {
        if (templateId.contains("_JOURNAL_CONTEXT_") || templateId.contains("_SERVLET_CONTEXT_") || templateId.contains("_TEMPLATE_CONTEXT_") || templateId.contains("_THEME_LOADER_CONTEXT_")) {
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Loading " + templateId);
        }
        ClassLoader classLoader = this._classLoader;
        int pos = templateId.indexOf("_CLASS_LOADER_CONTEXT_");
        if (pos >= 0) {
            classLoader = ClassLoaderPool.getClassLoader(templateId.substring(0, pos));
            templateId = templateId.substring(pos + "_CLASS_LOADER_CONTEXT_".length());
        }
        return classLoader.getResource(templateId);
    }
}

