/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.io.unsync.UnsyncCharArrayWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.template.TemplateResource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;

public class CacheTemplateResource
implements TemplateResource {
    private long _lastModified = System.currentTimeMillis();
    private final AtomicReference<String> _templateContent = new AtomicReference();
    private TemplateResource _templateResource;

    public CacheTemplateResource() {
    }

    public CacheTemplateResource(TemplateResource templateResource) {
        if (templateResource == null) {
            throw new IllegalArgumentException("Template resource is null");
        }
        this._templateResource = templateResource;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheTemplateResource)) {
            return false;
        }
        CacheTemplateResource cacheTemplateResource = (CacheTemplateResource)obj;
        return this._templateResource.equals(cacheTemplateResource._templateResource);
    }

    public TemplateResource getInnerTemplateResource() {
        return this._templateResource;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public Reader getReader() throws IOException {
        String templateContent = this._templateContent.get();
        if (templateContent != null) {
            return new UnsyncStringReader(templateContent);
        }
        try (Reader reader = this._templateResource.getReader();){
            char[] buffer = new char[1024];
            int result = -1;
            UnsyncCharArrayWriter unsyncCharArrayWriter = new UnsyncCharArrayWriter();
            while ((result = reader.read(buffer)) != -1) {
                unsyncCharArrayWriter.write(buffer, 0, result);
            }
            templateContent = unsyncCharArrayWriter.toString();
            this._templateContent.set(templateContent);
        }
        return new UnsyncStringReader(templateContent);
    }

    @Override
    public String getTemplateId() {
        return this._templateResource.getTemplateId();
    }

    public int hashCode() {
        return this._templateResource.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._lastModified = objectInput.readLong();
        this._templateResource = (TemplateResource)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this._lastModified);
        objectOutput.writeObject(this._templateResource);
    }
}

