/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.BaseTemplateResourceCache;
import com.liferay.portal.template.TemplateResourceParser;
import java.util.Set;

public abstract class BaseTemplateResourceLoader
implements TemplateResourceLoader {
    private static final Log _log = LogFactoryUtil.getLog(BaseTemplateResourceLoader.class);
    private String _name;
    private TemplateResourceCache _templateResourceCache;
    private Set<TemplateResourceParser> _templateResourceParsers;

    @Override
    public void clearCache() {
        this._templateResourceCache.clear();
    }

    @Override
    public void clearCache(String templateId) {
        this._templateResourceCache.remove(templateId);
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public TemplateResource getTemplateResource(String templateId) {
        if (!this._templateResourceCache.isEnabled()) {
            return this._loadFromParser(templateId);
        }
        TemplateResource templateResource = this._templateResourceCache.getTemplateResource(templateId);
        if (templateResource == BaseTemplateResourceCache.DUMMY_TEMPLATE_RESOURCE) {
            return null;
        }
        if (templateResource == null) {
            templateResource = this._loadFromParser(templateId);
            this._templateResourceCache.put(templateId, templateResource);
        }
        return templateResource;
    }

    @Override
    public boolean hasTemplateResource(String templateId) {
        TemplateResource templateResource = this.getTemplateResource(templateId);
        return templateResource != null;
    }

    protected void init(String name, Set<TemplateResourceParser> templateResourceParsers, TemplateResourceCache templateResourceCache) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException("Template resource loader name is null");
        }
        this._name = name;
        this._templateResourceParsers = templateResourceParsers;
        this._templateResourceCache = templateResourceCache;
    }

    private TemplateResource _loadFromParser(String templateId) {
        for (TemplateResourceParser templateResourceParser : this._templateResourceParsers) {
            try {
                TemplateResource templateResource;
                if (!templateResourceParser.isTemplateResourceValid(templateId, this.getName()) || (templateResource = templateResourceParser.getTemplateResource(templateId)) == null) continue;
                return templateResource;
            }
            catch (TemplateException te) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(StringBundler.concat("Unable to parse template ", templateId, " with parser ", templateResourceParser), te);
            }
        }
        return null;
    }
}

