/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.template.CacheTemplateResource;

public abstract class BaseTemplateResourceCache
implements TemplateResourceCache {
    protected static final TemplateResource DUMMY_TEMPLATE_RESOURCE = ProxyFactory.newDummyInstance(TemplateResource.class);
    private static final Log _log = LogFactoryUtil.getLog(BaseTemplateResourceCache.class);
    private long _modificationCheckInterval;
    private MultiVMPool _multiVMPool;
    private PortalCache<String, TemplateResource> _multiVMPortalCache;
    private String _portalCacheName;
    private SingleVMPool _singleVMPool;
    private PortalCache<String, TemplateResource> _singleVMPortalCache;
    private TemplateResourcePortalCacheListener _templateResourcePortalCacheListener;

    @Override
    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this._multiVMPortalCache.removeAll();
        this._singleVMPortalCache.removeAll();
    }

    @Override
    public TemplateResource getTemplateResource(String templateId) {
        if (!this.isEnabled()) {
            return null;
        }
        TemplateResource templateResource = this._singleVMPortalCache.get(templateId);
        if (templateResource == null) {
            templateResource = this._multiVMPortalCache.get(templateId);
        }
        if (templateResource != null && templateResource != DUMMY_TEMPLATE_RESOURCE && this._modificationCheckInterval > 0L) {
            long expireTime = templateResource.getLastModified() + this._modificationCheckInterval;
            if (System.currentTimeMillis() > expireTime) {
                this.remove(templateId);
                templateResource = null;
                if (_log.isDebugEnabled()) {
                    _log.debug("Remove expired template resource " + templateId);
                }
            }
        }
        return templateResource;
    }

    @Override
    public boolean isEnabled() {
        return this._modificationCheckInterval != 0L;
    }

    @Override
    public void put(String templateId, TemplateResource templateResource) {
        if (!this.isEnabled()) {
            return;
        }
        if (templateResource == null) {
            this._singleVMPortalCache.put(templateId, DUMMY_TEMPLATE_RESOURCE);
        } else if (templateResource instanceof URLTemplateResource) {
            this._singleVMPortalCache.put(templateId, new CacheTemplateResource(templateResource));
        } else if (templateResource instanceof CacheTemplateResource || templateResource instanceof StringTemplateResource) {
            this._multiVMPortalCache.put(templateId, templateResource);
        } else {
            this._multiVMPortalCache.put(templateId, new CacheTemplateResource(templateResource));
        }
    }

    @Override
    public void remove(String templateId) {
        if (!this.isEnabled()) {
            return;
        }
        this._multiVMPortalCache.remove(templateId);
        this._singleVMPortalCache.remove(templateId);
    }

    @Override
    public void setSecondLevelPortalCache(PortalCache<TemplateResource, ?> portalCache) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._templateResourcePortalCacheListener != null) {
            this._multiVMPortalCache.unregisterPortalCacheListener(this._templateResourcePortalCacheListener);
            this._singleVMPortalCache.unregisterPortalCacheListener(this._templateResourcePortalCacheListener);
        }
        this._templateResourcePortalCacheListener = new TemplateResourcePortalCacheListener(portalCache);
        this._multiVMPortalCache.registerPortalCacheListener(this._templateResourcePortalCacheListener);
        this._singleVMPortalCache.registerPortalCacheListener(this._templateResourcePortalCacheListener);
    }

    protected void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        this._multiVMPool.removePortalCache(this._portalCacheName);
        this._singleVMPool.removePortalCache(this._portalCacheName);
    }

    protected void init(long modificationCheckInterval, MultiVMPool multiVMPool, SingleVMPool singleVMPool, String portalCacheName) {
        this._modificationCheckInterval = modificationCheckInterval;
        this._multiVMPool = multiVMPool;
        this._singleVMPool = singleVMPool;
        this._portalCacheName = portalCacheName;
        if (this.isEnabled()) {
            this._multiVMPortalCache = multiVMPool.getPortalCache(portalCacheName);
            this._singleVMPortalCache = singleVMPool.getPortalCache(portalCacheName);
        }
    }

    private class TemplateResourcePortalCacheListener
    implements PortalCacheListener<String, TemplateResource> {
        private final PortalCache<TemplateResource, ?> _portalCache;

        @Override
        public void dispose() {
        }

        @Override
        public void notifyEntryEvicted(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove(templateResource);
            }
        }

        @Override
        public void notifyEntryExpired(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove(templateResource);
            }
        }

        @Override
        public void notifyEntryPut(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
        }

        @Override
        public void notifyEntryRemoved(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove(templateResource);
            }
        }

        @Override
        public void notifyEntryUpdated(PortalCache<String, TemplateResource> portalCache, String key, TemplateResource templateResource, int timeToLive) throws PortalCacheException {
            if (templateResource != null) {
                this._portalCache.remove(templateResource);
            }
        }

        @Override
        public void notifyRemoveAll(PortalCache<String, TemplateResource> portalCache) throws PortalCacheException {
            this._portalCache.removeAll();
        }

        private TemplateResourcePortalCacheListener(PortalCache<TemplateResource, ?> portalCache) {
            this._portalCache = portalCache;
        }
    }
}

