/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.TemplateContextHelper;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseTemplate
implements Template {
    protected Map<String, Object> context;
    private final TemplateContextHelper _templateContextHelper;
    private final TemplateResource _templateResource;

    public BaseTemplate(TemplateResource templateResource, Map<String, Object> context, TemplateContextHelper templateContextHelper) {
        if (templateResource == null) {
            throw new IllegalArgumentException("Template resource is null");
        }
        if (templateContextHelper == null) {
            throw new IllegalArgumentException("Template context helper is null");
        }
        this._templateResource = templateResource;
        this.context = new HashMap<String, Object>();
        if (context != null) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        this._templateContextHelper = templateContextHelper;
    }

    @Override
    public void clear() {
        this.context.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.context.entrySet();
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.context.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.context.keySet();
    }

    @Override
    public void prepare(HttpServletRequest httpServletRequest) {
        this._templateContextHelper.prepare(this, httpServletRequest);
    }

    @Override
    public void processTemplate(Writer writer) throws TemplateException {
        try {
            this.processTemplate(this._templateResource, writer);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process template " + this._templateResource.getTemplateId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processTemplate(Writer writer, Supplier<TemplateResource> errorTemplateResourceSupplier) throws TemplateException {
        if (errorTemplateResourceSupplier == null) {
            this.processTemplate(writer);
            return;
        }
        Writer oldWriter = (Writer)this.get("writer");
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            this.put("writer", (Object)unsyncStringWriter);
            this.processTemplate(this._templateResource, unsyncStringWriter);
            StringBundler sb = unsyncStringWriter.getStringBundler();
            sb.writeTo(writer);
        }
        catch (Exception e) {
            TemplateResource errorTemplateResource = errorTemplateResourceSupplier.get();
            if (errorTemplateResource == null) {
                throw new TemplateException("Unable to process template " + this._templateResource.getTemplateId(), e);
            }
            this.put("writer", (Object)writer);
            this.handleException(this._templateResource, errorTemplateResource, e, writer);
        }
        finally {
            this.put("writer", (Object)oldWriter);
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        return this.context.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.context.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.context.remove(key);
    }

    @Override
    public int size() {
        return this.context.size();
    }

    @Override
    public Collection<Object> values() {
        return this.context.values();
    }

    protected void cacheTemplateResource(TemplateResourceCache templateResourceCache, TemplateResource templateResource) {
        TemplateResource cachedTemplateResource = templateResourceCache.getTemplateResource(templateResource.getTemplateId());
        if (cachedTemplateResource == null || !templateResource.equals(cachedTemplateResource)) {
            templateResourceCache.put(templateResource.getTemplateId(), templateResource);
        }
    }

    protected String getTemplateResourceUUID(TemplateResource templateResource) {
        return "TEMPLATE_RESOURCE_UUID".concat("#").concat(templateResource.getTemplateId());
    }

    protected abstract void handleException(TemplateResource var1, TemplateResource var2, Exception var3, Writer var4) throws TemplateException;

    protected abstract void processTemplate(TemplateResource var1, Writer var2) throws Exception;
}

