/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.struts.Definition;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class TilesUtil {
    public static final String DEFINITION = "com.liferay.portal.struts.definition";
    public static final String DEFINITIONS = "com.liferay.portal.struts.definitions";

    public static void loadDefinitions(ServletContext servletContext) throws Exception {
        HashMap<String, Definition> definitions = new HashMap<String, Definition>();
        ArrayList<Element> deferedElements = new ArrayList<Element>();
        try (InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/tiles-defs.xml");){
            Document document = SAXReaderUtil.read(inputStream, false);
            Element rootElement = document.getRootElement();
            for (Element definitionElement : rootElement.elements("definition")) {
                String parentName = definitionElement.attributeValue("extends");
                if (parentName == null) {
                    TilesUtil._addDefinition(definitions, definitionElement, null);
                    continue;
                }
                Definition parentDefinition = (Definition)definitions.get(parentName);
                if (parentDefinition == null) {
                    deferedElements.add(rootElement);
                    continue;
                }
                TilesUtil._addDefinition(definitions, definitionElement, parentDefinition);
            }
            for (Element definitionElement : deferedElements) {
                Definition parentDefinition = (Definition)definitions.get(definitionElement.attributeValue("extends"));
                TilesUtil._addDefinition(definitions, definitionElement, parentDefinition);
            }
            servletContext.setAttribute(DEFINITIONS, definitions);
        }
    }

    private static void _addDefinition(Map<String, Definition> definitions, Element definitionElement, Definition parentDefinition) {
        String name = definitionElement.attributeValue("name");
        HashMap<String, String> attributes = new HashMap<String, String>();
        String path = definitionElement.attributeValue("path");
        if (parentDefinition != null) {
            attributes.putAll(parentDefinition.getAttributes());
            if (path == null) {
                path = parentDefinition.getPath();
            }
        }
        for (Element putElement : definitionElement.elements("put")) {
            attributes.put(putElement.attributeValue("name"), putElement.attributeValue("value"));
        }
        definitions.put(name, new Definition(path, attributes));
    }
}

