/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StrutsUtil {
    public static final String TEXT_HTML_DIR = "/html";
    private static final Log _log = LogFactoryUtil.getLog(StrutsUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forward(String uri, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug("Forward URI " + uri);
        }
        if (uri.equals("/common/null.jsp")) {
            return;
        }
        if (!httpServletResponse.isCommitted()) {
            String path = TEXT_HTML_DIR.concat(uri);
            if (_log.isDebugEnabled()) {
                _log.debug("Forward path " + path);
            }
            RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher(servletContext, path);
            try {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) return;
                _log.warn(ioe, ioe);
                return;
            }
            catch (ServletException se1) {
                httpServletRequest.setAttribute("javax.servlet.jsp.jspException", (Object)se1.getRootCause());
                String errorPath = "/html/common/error.jsp";
                requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher(servletContext, errorPath);
                try {
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                catch (IOException ioe2) {
                    if (!_log.isWarnEnabled()) return;
                    _log.warn(ioe2, ioe2);
                    return;
                }
                catch (ServletException se2) {
                    throw se2;
                }
            }
        } else {
            if (!_log.isWarnEnabled()) return;
            _log.warn(uri + " is already committed");
        }
    }
}

