/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.LayoutPermissionException;
import com.liferay.portal.kernel.exception.PortletActiveException;
import com.liferay.portal.kernel.exception.UserActiveException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.model.UserTrackerPath;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.InterruptedPortletRequestWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.persistence.UserTrackerPathUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.struts.Action;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.struts.Definition;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.struts.model.ActionForward;
import com.liferay.portal.struts.model.ActionMapping;
import com.liferay.portal.struts.model.ModuleConfig;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortalRequestProcessor {
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String _PATH_C = "/c";
    private static final String _PATH_COMMON = "/common";
    private static final String _PATH_J_SECURITY_CHECK = "/j_security_check";
    private static final String _PATH_PORTAL = "/portal";
    private static final String _PATH_PORTAL_API_JSONWS = "/portal/api/jsonws";
    private static final String _PATH_PORTAL_ERROR = "/portal/error";
    private static final String _PATH_PORTAL_EXPIRE_SESSION = "/portal/expire_session";
    private static final String _PATH_PORTAL_EXTEND_SESSION = "/portal/extend_session";
    private static final String _PATH_PORTAL_FLASH = "/portal/flash";
    private static final String _PATH_PORTAL_J_LOGIN = "/portal/j_login";
    private static final String _PATH_PORTAL_JSON_SERVICE = "/portal/json_service";
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LICENSE = "/portal/license";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static final String _PATH_PORTAL_PROTECTED = "/portal/protected";
    private static final String _PATH_PORTAL_RENDER_PORTLET = "/portal/render_portlet";
    private static final String _PATH_PORTAL_RESILIENCY = "/portal/resiliency";
    private static final String _PATH_PORTAL_SETUP_WIZARD = "/portal/setup_wizard";
    private static final String _PATH_PORTAL_STATUS = "/portal/status";
    private static final String _PATH_PORTAL_TCK = "/portal/tck";
    private static final String _PATH_PORTAL_TERMS_OF_USE = "/portal/terms_of_use";
    private static final String _PATH_PORTAL_UPDATE_EMAIL_ADDRESS = "/portal/update_email_address";
    private static final String _PATH_PORTAL_UPDATE_LANGUAGE = "/portal/update_language";
    private static final String _PATH_PORTAL_UPDATE_PASSWORD = "/portal/update_password";
    private static final String _PATH_PORTAL_UPDATE_REMINDER_QUERY = "/portal/update_reminder_query";
    private static final String _PATH_PORTAL_UPDATE_TERMS_OF_USE = "/portal/update_terms_of_use";
    private static final String _PATH_PORTAL_VERIFY_EMAIL_ADDRESS = "/portal/verify_email_address";
    private static final Log _log = LogFactoryUtil.getLog(PortalRequestProcessor.class);
    private final Map<String, Definition> _definitions;
    private final Set<String> _lastPaths;
    private final ModuleConfig _moduleConfig;
    private final Set<String> _publicPaths;
    private final ServletContext _servletContext;
    private final Set<String> _trackerIgnorePaths;

    public PortalRequestProcessor(ServletContext servletContext, ModuleConfig moduleConfig) {
        this._servletContext = servletContext;
        this._moduleConfig = moduleConfig;
        this._definitions = (Map)servletContext.getAttribute("com.liferay.portal.struts.definitions");
        this._lastPaths = new HashSet<String>(Arrays.asList(PropsUtil.getArray("auth.forward.last.paths")));
        this._lastPaths.add(_PATH_PORTAL_LAYOUT);
        this._publicPaths = new HashSet<String>();
        this._publicPaths.add(_PATH_C);
        this._publicPaths.add(_PATH_PORTAL_API_JSONWS);
        this._publicPaths.add(_PATH_PORTAL_FLASH);
        this._publicPaths.add(_PATH_PORTAL_J_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_LAYOUT);
        this._publicPaths.add(_PATH_PORTAL_LICENSE);
        this._publicPaths.add(_PATH_PORTAL_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_RENDER_PORTLET);
        this._publicPaths.add(_PATH_PORTAL_RESILIENCY);
        this._publicPaths.add(_PATH_PORTAL_TCK);
        this._publicPaths.add(_PATH_PORTAL_UPDATE_LANGUAGE);
        this._publicPaths.add(_PATH_PORTAL_UPDATE_PASSWORD);
        this._publicPaths.add(_PATH_PORTAL_VERIFY_EMAIL_ADDRESS);
        this._publicPaths.add(PropsValues.AUTH_LOGIN_DISABLED_PATH);
        this._trackerIgnorePaths = new HashSet<String>(Arrays.asList(PropsUtil.getArray("session.tracker.ignore.paths")));
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String path = this._processPath(httpServletRequest);
        ActionMapping actionMapping = this._moduleConfig.getActionMapping(path);
        if (actionMapping == null) {
            String lastPath = this._getLastPath(httpServletRequest);
            if (_log.isDebugEnabled()) {
                _log.debug("Last path " + lastPath);
            }
            httpServletResponse.sendRedirect(lastPath);
            return;
        }
        this._process(actionMapping, httpServletRequest, httpServletResponse);
    }

    private String _findPath(HttpServletRequest httpServletRequest) {
        String path = (String)httpServletRequest.getAttribute(INCLUDE_PATH_INFO);
        if (path == null) {
            path = httpServletRequest.getPathInfo();
        }
        if (path != null && path.length() > 0) {
            return path;
        }
        path = (String)httpServletRequest.getAttribute(INCLUDE_SERVLET_PATH);
        if (path == null) {
            path = httpServletRequest.getServletPath();
        }
        int periodIndex = path.lastIndexOf(46);
        int slashIndex = path.lastIndexOf(47);
        if (periodIndex >= 0 && periodIndex > slashIndex) {
            path = path.substring(0, periodIndex);
        }
        return path;
    }

    private String _getFriendlyTrackerPath(String path, ThemeDisplay themeDisplay, HttpServletRequest httpServletRequest) throws Exception {
        if (!path.equals(_PATH_PORTAL_LAYOUT)) {
            return null;
        }
        long plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        if (plid == 0L) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        String layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL(layout, themeDisplay);
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (Validator.isNull(portletId)) {
            return layoutFriendlyURL;
        }
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
        if (portlet == null) {
            String strutsPath = path.substring(1, path.lastIndexOf(47));
            portlet = PortletLocalServiceUtil.getPortletByStrutsPath(companyId, strutsPath);
        }
        if (portlet == null || !portlet.isActive()) {
            return layoutFriendlyURL.concat("?").concat(httpServletRequest.getQueryString());
        }
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper == null) {
            return layoutFriendlyURL.concat("?").concat(httpServletRequest.getQueryString());
        }
        String namespace = PortalUtil.getPortletNamespace(portletId);
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, portlet, layout, "RENDER_PHASE");
        Map parameterMap = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(namespace)) continue;
            key = key.substring(namespace.length());
            portletURL.setParameter(key, (String[])entry.getValue());
        }
        String portletFriendlyURL = friendlyURLMapper.buildPath(portletURL);
        if (portletFriendlyURL != null) {
            return layoutFriendlyURL.concat(portletFriendlyURL);
        }
        return layoutFriendlyURL.concat("?").concat(httpServletRequest.getQueryString());
    }

    private String _getLastPath(HttpServletRequest httpServletRequest) {
        ActionMapping actionMapping;
        HttpSession session = httpServletRequest.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL(httpServletRequest, false) : PortalUtil.getPortalURL(httpServletRequest);
        StringBundler sb = new StringBundler(7);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathMain());
        sb.append(_PATH_PORTAL_LAYOUT);
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
            if (httpServletRequest.getRemoteUser() != null) {
                sb.append("?");
                sb.append("p_l_id");
                sb.append("=");
                sb.append(0L);
            }
            return sb.toString();
        }
        LastPath lastPath = (LastPath)session.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return sb.toString();
        }
        String parameters = lastPath.getParameters();
        String contextPath = lastPath.getContextPath();
        if (contextPath.equals(themeDisplay.getPathMain()) && ((actionMapping = this._moduleConfig.getActionMapping(lastPath.getPath())) == null || parameters.isEmpty())) {
            return sb.toString();
        }
        StringBundler lastPathSB = new StringBundler(4);
        lastPathSB.append(portalURL);
        lastPathSB.append(lastPath.getContextPath());
        lastPathSB.append(lastPath.getPath());
        lastPathSB.append(parameters);
        return lastPathSB.toString();
    }

    private void _internalModuleRelativeForward(String uri, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Definition definition = this._definitions.get(uri);
        if (definition != null) {
            httpServletRequest.setAttribute("com.liferay.portal.struts.definition", (Object)definition);
            uri = definition.getPath();
        }
        StrutsUtil.forward(uri, this._servletContext, httpServletRequest, httpServletResponse);
    }

    private boolean _isPortletPath(String path) {
        return path != null && !path.equals(_PATH_C) && !path.startsWith(_PATH_COMMON) && !path.contains(_PATH_J_SECURITY_CHECK) && !path.startsWith(_PATH_PORTAL);
    }

    private boolean _isPublicPath(String path) {
        return path != null && (this._publicPaths.contains(path) || path.startsWith(_PATH_COMMON) || AuthPublicPathRegistry.contains(path));
    }

    private void _process(ActionMapping actionMapping, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this._processLocale(httpServletRequest);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (!this._processRoles(httpServletRequest, httpServletResponse, actionMapping)) {
            return;
        }
        if (!this._processForward(httpServletRequest, httpServletResponse, actionMapping)) {
            return;
        }
        Action action = actionMapping.getAction();
        try {
            ActionForward actionForward = action.execute(actionMapping, httpServletRequest, httpServletResponse);
            if (actionForward != null) {
                this._internalModuleRelativeForward(actionForward.getPath(), httpServletRequest, httpServletResponse);
            }
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean _processForward(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException, ServletException {
        String forward = actionMapping.getForward();
        if (forward == null) {
            return true;
        }
        this._internalModuleRelativeForward(forward, httpServletRequest, httpServletResponse);
        return false;
    }

    private void _processLocale(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession();
        if (session.getAttribute("LOCALE") != null) {
            return;
        }
        Locale locale = httpServletRequest.getLocale();
        if (locale != null) {
            session.setAttribute("LOCALE", (Object)locale);
        }
    }

    private String _processPath(HttpServletRequest httpServletRequest) {
        String path = this._findPath(httpServletRequest);
        HttpSession session = httpServletRequest.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserTracker userTracker = LiveUsers.getUserTracker(themeDisplay.getCompanyId(), session.getId());
        if (!(userTracker == null || path.equals(_PATH_C) || path.contains(_PATH_J_SECURITY_CHECK) || path.contains(_PATH_PORTAL_PROTECTED) || this._trackerIgnorePaths.contains(path))) {
            int pos;
            String fullPath = null;
            try {
                if (PropsValues.SESSION_TRACKER_FRIENDLY_PATHS_ENABLED) {
                    fullPath = this._getFriendlyTrackerPath(path, themeDisplay, httpServletRequest);
                }
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            String fullPathWithoutQueryString = fullPath;
            if (Validator.isNull(fullPath)) {
                String queryString = httpServletRequest.getQueryString();
                fullPathWithoutQueryString = path;
                fullPath = Validator.isNotNull(queryString) ? path.concat("?").concat(queryString) : path;
            }
            if ((pos = fullPathWithoutQueryString.indexOf("?")) != -1) {
                fullPathWithoutQueryString = fullPathWithoutQueryString.substring(0, pos);
            }
            if (!this._trackerIgnorePaths.contains(fullPathWithoutQueryString)) {
                UserTrackerPath userTrackerPath = UserTrackerPathUtil.create(0L);
                userTrackerPath.setUserTrackerId(userTracker.getUserTrackerId());
                userTrackerPath.setPath(fullPath);
                userTrackerPath.setPathDate(new Date());
                userTracker.addPath(userTrackerPath);
            }
        }
        String remoteUser = httpServletRequest.getRemoteUser();
        User user = null;
        try {
            user = PortalUtil.getUser(httpServletRequest);
        }
        catch (Exception pos) {
            // empty catch block
        }
        if (this._lastPaths.contains(path) && !this._trackerIgnorePaths.contains(path)) {
            boolean saveLastPath = ParamUtil.getBoolean(httpServletRequest, "saveLastPath", true);
            if (themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() || themeDisplay.isStatePopUp() || !StringUtil.equalsIgnoreCase(httpServletRequest.getMethod(), "GET")) {
                saveLastPath = false;
            }
            if (saveLastPath) {
                LastPath lastPath = (LastPath)httpServletRequest.getAttribute("LAST_PATH");
                if (lastPath == null) {
                    lastPath = new LastPath(themeDisplay.getPathMain(), path, HttpUtil.parameterMapToString(httpServletRequest.getParameterMap()));
                }
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        if (PropsValues.SETUP_WIZARD_ENABLED) {
            if (!path.equals(_PATH_PORTAL_LICENSE) && !path.equals(_PATH_PORTAL_STATUS)) {
                return _PATH_PORTAL_SETUP_WIZARD;
            }
        } else if (path.equals(_PATH_PORTAL_SETUP_WIZARD)) {
            return _PATH_PORTAL_LAYOUT;
        }
        if (remoteUser != null || user != null) {
            if (path.equals(_PATH_PORTAL_LOGOUT)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_EXPIRE_SESSION) || path.equals(_PATH_PORTAL_EXTEND_SESSION)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_UPDATE_LANGUAGE)) {
                return path;
            }
            if (path.equals(_PATH_PORTAL_UPDATE_TERMS_OF_USE)) {
                return path;
            }
        }
        if (remoteUser != null && user == null) {
            return _PATH_PORTAL_LOGOUT;
        }
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (user != null) {
            if (!user.isActive()) {
                SessionErrors.add(session, UserActiveException.class.getName());
                return _PATH_PORTAL_ERROR;
            }
            if (!(path.equals(_PATH_PORTAL_JSON_SERVICE) || path.equals(_PATH_PORTAL_RENDER_PORTLET) || themeDisplay.isImpersonated() || InterruptedPortletRequestWhitelistUtil.isPortletInvocationWhitelisted(companyId, portletId, PortalUtil.getStrutsAction(httpServletRequest)))) {
                block39: {
                    if (!user.isTermsOfUseComplete()) {
                        return _PATH_PORTAL_TERMS_OF_USE;
                    }
                    if (!user.isEmailAddressVerificationComplete()) {
                        if (path.equals(_PATH_PORTAL_UPDATE_EMAIL_ADDRESS)) {
                            return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
                        }
                        return _PATH_PORTAL_VERIFY_EMAIL_ADDRESS;
                    }
                    if (user.isPasswordReset()) {
                        try {
                            PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                            if (passwordPolicy == null || passwordPolicy.isChangeable()) {
                                return _PATH_PORTAL_UPDATE_PASSWORD;
                            }
                            break block39;
                        }
                        catch (Exception e) {
                            _log.error(e, e);
                            return _PATH_PORTAL_UPDATE_PASSWORD;
                        }
                    }
                    if (path.equals(_PATH_PORTAL_UPDATE_PASSWORD)) {
                        return _PATH_PORTAL_LAYOUT;
                    }
                }
                if (!user.isEmailAddressComplete()) {
                    return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
                }
                if (!user.isDefaultUser() && !user.isReminderQueryComplete()) {
                    return _PATH_PORTAL_UPDATE_REMINDER_QUERY;
                }
            }
        } else if (!this._isPublicPath(path)) {
            SessionErrors.add(session, PrincipalException.class.getName());
            return _PATH_PORTAL_LOGIN;
        }
        if (SessionErrors.contains(session, LayoutPermissionException.class.getName())) {
            return _PATH_PORTAL_ERROR;
        }
        return path;
    }

    private boolean _processRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionMapping actionMapping) throws IOException, ServletException {
        String path = actionMapping.getPath();
        if (this._isPublicPath(path)) {
            return true;
        }
        boolean authorized = true;
        User user = null;
        try {
            user = PortalUtil.getUser(httpServletRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user != null && this._isPortletPath(path)) {
            try {
                if (path.equals(_PATH_PORTAL_LOGOUT)) {
                    return true;
                }
                Portlet portlet = null;
                String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
                if (Validator.isNotNull(portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById(user.getCompanyId(), portletId);
                }
                String strutsPath = path.substring(1, path.lastIndexOf(47));
                if (portlet != null) {
                    if (!strutsPath.equals(portlet.getStrutsPath())) {
                        throw new PrincipalException.MustBePortletStrutsPath(strutsPath, portletId);
                    }
                } else {
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath(user.getCompanyId(), strutsPath);
                }
                if (portlet != null && portlet.isActive() && !portlet.isSystem()) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    Layout layout = themeDisplay.getLayout();
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    if (!PortletPermissionUtil.contains(permissionChecker, layout, portlet, "VIEW")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, Portlet.class.getName(), portlet.getPortletId(), "VIEW");
                    }
                } else if (portlet != null && !portlet.isActive()) {
                    SessionErrors.add(httpServletRequest, PortletActiveException.class.getName());
                    authorized = false;
                }
            }
            catch (Exception e) {
                SessionErrors.add(httpServletRequest, PrincipalException.class.getName());
                authorized = false;
            }
        }
        if (!authorized) {
            ActionForward actionForward = actionMapping.getActionForward(_PATH_PORTAL_ERROR);
            if (actionForward != null) {
                this._internalModuleRelativeForward(actionForward.getPath(), httpServletRequest, httpServletResponse);
            }
            return false;
        }
        return true;
    }
}

