/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sites.kernel.util.SitesUtil;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FindStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(FindStrutsAction.class);

    @Override
    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            long groupId;
            long primaryKey;
            block10: {
                primaryKey = ParamUtil.getLong(httpServletRequest, this.getPrimaryKeyParameterName());
                groupId = ParamUtil.getLong(httpServletRequest, "groupId", themeDisplay.getScopeGroupId());
                if (primaryKey > 0L) {
                    try {
                        long overrideGroupId = this.getGroupId(primaryKey);
                        if (overrideGroupId > 0L) {
                            groupId = overrideGroupId;
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isDebugEnabled()) break block10;
                        _log.debug(e, e);
                    }
                }
            }
            PortletLayoutFinder portletLayoutFinder = this.getPortletLayoutFinder();
            PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
            long plid = result.getPlid();
            Layout layout = FindStrutsAction._setTargetLayout(httpServletRequest, groupId, plid);
            LayoutPermissionUtil.check(themeDisplay.getPermissionChecker(), layout, true, "VIEW");
            String portletId = result.getPortletId();
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, portletId, layout, "RENDER_PHASE");
            this.addRequiredParameters(httpServletRequest, portletId, portletURL);
            boolean inheritRedirect = ParamUtil.getBoolean(httpServletRequest, "inheritRedirect");
            String redirect = null;
            if (inheritRedirect) {
                String noSuchEntryRedirect = ParamUtil.getString(httpServletRequest, "noSuchEntryRedirect");
                redirect = HttpUtil.getParameter(noSuchEntryRedirect, "redirect", false);
                redirect = HttpUtil.decodeURL(redirect);
            } else {
                redirect = ParamUtil.getString(httpServletRequest, "redirect");
            }
            if (Validator.isNotNull(redirect)) {
                portletURL.setParameter("redirect", redirect);
            }
            this.setPrimaryKeyParameter(portletURL, primaryKey);
            portletURL.setPortletMode(PortletMode.VIEW);
            portletURL.setWindowState(WindowState.NORMAL);
            portletURL = this.processPortletURL(httpServletRequest, portletURL);
            httpServletResponse.sendRedirect(portletURL.toString());
        }
        catch (Exception e) {
            String noSuchEntryRedirect = ParamUtil.getString(httpServletRequest, "noSuchEntryRedirect");
            noSuchEntryRedirect = PortalUtil.escapeRedirect(noSuchEntryRedirect);
            if (Validator.isNotNull(noSuchEntryRedirect) && (e instanceof NoSuchLayoutException || e instanceof PrincipalException)) {
                httpServletResponse.sendRedirect(noSuchEntryRedirect);
            }
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
        }
        return null;
    }

    protected abstract void addRequiredParameters(HttpServletRequest var1, String var2, PortletURL var3);

    protected abstract long getGroupId(long var1) throws Exception;

    protected abstract PortletLayoutFinder getPortletLayoutFinder();

    protected abstract String getPrimaryKeyParameterName();

    protected PortletURL processPortletURL(HttpServletRequest httpServletRequest, PortletURL portletURL) throws Exception {
        return portletURL;
    }

    protected void setPrimaryKeyParameter(PortletURL portletURL, long primaryKey) throws Exception {
        portletURL.setParameter(this.getPrimaryKeyParameterName(), String.valueOf(primaryKey));
    }

    private static Layout _setTargetLayout(HttpServletRequest httpServletRequest, long groupId, long plid) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        if (groupId == layout.getGroupId() || group.getParentGroupId() == layout.getGroupId() || layout.isPrivateLayout() && !SitesUtil.isUserGroupLayoutSetViewable(permissionChecker, layout.getGroup())) {
            return layout;
        }
        layout = new VirtualLayout(layout, group);
        httpServletRequest.setAttribute("LAYOUT", (Object)layout);
        return layout;
    }
}

