/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AuthPublicPathRegistry {
    private static final Set<String> _paths = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ServiceTracker<Object, Object> _serviceTracker;

    public static boolean contains(String path) {
        return _paths.contains(path);
    }

    public static void register(String ... paths) {
        Collections.addAll(_paths, paths);
    }

    public static void unregister(String ... paths) {
        _paths.removeAll(Arrays.asList(paths));
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(registry.getFilter("(&(auth.public.path=*)(objectClass=java.lang.Object))"), new AuthPublicTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class AuthPublicTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private AuthPublicTrackerCustomizer() {
        }

        @Override
        public Object addingService(ServiceReference<Object> serviceReference) {
            List<String> paths = StringPlus.asList(serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                _paths.add(path);
            }
            Registry registry = RegistryUtil.getRegistry();
            return registry.getService(serviceReference);
        }

        @Override
        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
        }

        @Override
        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            List<String> paths = StringPlus.asList(serviceReference.getProperty("auth.public.path"));
            for (String path : paths) {
                _paths.remove(path);
            }
        }
    }
}

