/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class DefaultTransactionExecutor
implements TransactionExecutor,
TransactionHandler {
    private final PlatformTransactionManager _platformTransactionManager;

    public DefaultTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    @Override
    public void commit(TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        this._commit(this._platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter, null);
    }

    @Override
    public <T> T execute(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<T, Throwable> unsafeSupplier) throws Throwable {
        return this._execute(this._platformTransactionManager, transactionAttributeAdapter, unsafeSupplier);
    }

    @Override
    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    @Override
    public void rollback(Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) throws Throwable {
        throw this._rollback(this._platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
    }

    @Override
    public TransactionStatusAdapter start(TransactionAttributeAdapter transactionAttributeAdapter) {
        return this._start(this._platformTransactionManager, transactionAttributeAdapter);
    }

    private void _commit(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter, Throwable applicationThrowable) {
        Throwable throwable = null;
        try {
            platformTransactionManager.commit(transactionStatusAdapter.getTransactionStatus());
        }
        catch (Throwable t) {
            if (applicationThrowable != null) {
                t.addSuppressed(applicationThrowable);
            }
            throwable = t;
            throw t;
        }
        finally {
            if (throwable != null) {
                TransactionLifecycleManager.fireTransactionRollbackedEvent(transactionAttributeAdapter, transactionStatusAdapter, throwable);
            } else {
                TransactionLifecycleManager.fireTransactionCommittedEvent(transactionAttributeAdapter, transactionStatusAdapter);
            }
            TransactionExecutorThreadLocal.popTransactionExecutor();
        }
    }

    private <T> T _execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<T, Throwable> unsafeSupplier) throws Throwable {
        TransactionStatusAdapter transactionStatusAdapter = this._start(platformTransactionManager, transactionAttributeAdapter);
        T returnValue = null;
        try {
            returnValue = unsafeSupplier.get();
        }
        catch (Throwable throwable) {
            throw this._rollback(platformTransactionManager, throwable, transactionAttributeAdapter, transactionStatusAdapter);
        }
        this._commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter, null);
        return returnValue;
    }

    private Throwable _rollback(PlatformTransactionManager platformTransactionManager, Throwable throwable, TransactionAttributeAdapter transactionAttributeAdapter, TransactionStatusAdapter transactionStatusAdapter) {
        if (transactionAttributeAdapter.rollbackOn(throwable)) {
            try {
                platformTransactionManager.rollback(transactionStatusAdapter.getTransactionStatus());
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                throw t;
            }
            finally {
                TransactionLifecycleManager.fireTransactionRollbackedEvent(transactionAttributeAdapter, transactionStatusAdapter, throwable);
                TransactionExecutorThreadLocal.popTransactionExecutor();
            }
        } else {
            this._commit(platformTransactionManager, transactionAttributeAdapter, transactionStatusAdapter, throwable);
        }
        return throwable;
    }

    private TransactionStatusAdapter _start(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter) {
        TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(platformTransactionManager.getTransaction((TransactionDefinition)transactionAttributeAdapter));
        TransactionExecutorThreadLocal.pushTransactionExecutor(this);
        TransactionLifecycleManager.fireTransactionCreatedEvent(transactionAttributeAdapter, transactionStatusAdapter);
        return transactionStatusAdapter;
    }
}

