/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.spring.transaction.CallbackPreferringTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class CounterCallbackPreferringTransactionExecutor
extends CallbackPreferringTransactionExecutor {
    public CounterCallbackPreferringTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        super(platformTransactionManager);
    }

    @Override
    protected TransactionCallback<Object> createTransactionCallback(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<Object, Throwable> unsafeSupplier) {
        return new CounterCallbackPreferringTransactionCallback(transactionAttributeAdapter, unsafeSupplier);
    }

    private static class CounterCallbackPreferringTransactionCallback
    implements TransactionCallback<Object> {
        private final TransactionAttributeAdapter _transactionAttributeAdapter;
        private final UnsafeSupplier<Object, Throwable> _unsafeSupplier;

        public Object doInTransaction(TransactionStatus transactionStatus) {
            try {
                return this._unsafeSupplier.get();
            }
            catch (Throwable throwable) {
                if (this._transactionAttributeAdapter.rollbackOn(throwable)) {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new CallbackPreferringTransactionExecutor.ThrowableHolderException(throwable);
                }
                return new CallbackPreferringTransactionExecutor.ThrowableHolder(throwable);
            }
        }

        private CounterCallbackPreferringTransactionCallback(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<Object, Throwable> unsafeSupplier) {
            this._transactionAttributeAdapter = transactionAttributeAdapter;
            this._unsafeSupplier = unsafeSupplier;
        }
    }
}

