/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.transaction.TransactionLifecycleManager;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;

public class CallbackPreferringTransactionExecutor
implements TransactionExecutor {
    private final PlatformTransactionManager _platformTransactionManager;

    public CallbackPreferringTransactionExecutor(PlatformTransactionManager platformTransactionManager) {
        this._platformTransactionManager = platformTransactionManager;
    }

    @Override
    public <T> T execute(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<T, Throwable> unsafeSupplier) throws Throwable {
        return this._execute(this._platformTransactionManager, transactionAttributeAdapter, unsafeSupplier);
    }

    @Override
    public PlatformTransactionManager getPlatformTransactionManager() {
        return this._platformTransactionManager;
    }

    protected TransactionCallback<Object> createTransactionCallback(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<Object, Throwable> unsafeSupplier) {
        return new CallbackPreferringTransactionCallback(transactionAttributeAdapter, unsafeSupplier);
    }

    private <T> T _execute(PlatformTransactionManager platformTransactionManager, TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<T, Throwable> unsafeSupplier) throws Throwable {
        CallbackPreferringPlatformTransactionManager callbackPreferringPlatformTransactionManager = (CallbackPreferringPlatformTransactionManager)platformTransactionManager;
        try {
            Object result = callbackPreferringPlatformTransactionManager.execute((TransactionDefinition)transactionAttributeAdapter, this.createTransactionCallback(transactionAttributeAdapter, unsafeSupplier));
            if (result instanceof ThrowableHolder) {
                ThrowableHolder throwableHolder = (ThrowableHolder)result;
                throw throwableHolder.getThrowable();
            }
            return (T)result;
        }
        catch (ThrowableHolderException the) {
            throw the.getCause();
        }
    }

    private class CallbackPreferringTransactionCallback
    implements TransactionCallback<Object> {
        private final TransactionAttributeAdapter _transactionAttributeAdapter;
        private final UnsafeSupplier<Object, Throwable> _unsafeSupplier;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInTransaction(TransactionStatus transactionStatus) {
            TransactionStatusAdapter transactionStatusAdapter = new TransactionStatusAdapter(transactionStatus);
            TransactionExecutorThreadLocal.pushTransactionExecutor(CallbackPreferringTransactionExecutor.this);
            TransactionLifecycleManager.fireTransactionCreatedEvent(this._transactionAttributeAdapter, transactionStatusAdapter);
            boolean rollback = false;
            try {
                Object object = this._unsafeSupplier.get();
                return object;
            }
            catch (Throwable throwable) {
                if (this._transactionAttributeAdapter.rollbackOn(throwable)) {
                    TransactionLifecycleManager.fireTransactionRollbackedEvent(this._transactionAttributeAdapter, transactionStatusAdapter, throwable);
                    if (transactionStatus.isNewTransaction()) {
                        rollback = true;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new ThrowableHolderException(throwable);
                }
                ThrowableHolder throwableHolder = new ThrowableHolder(throwable);
                return throwableHolder;
            }
            finally {
                if (!rollback) {
                    TransactionLifecycleManager.fireTransactionCommittedEvent(this._transactionAttributeAdapter, transactionStatusAdapter);
                }
                TransactionExecutorThreadLocal.popTransactionExecutor();
            }
        }

        private CallbackPreferringTransactionCallback(TransactionAttributeAdapter transactionAttributeAdapter, UnsafeSupplier<Object, Throwable> unsafeSupplier) {
            this._transactionAttributeAdapter = transactionAttributeAdapter;
            this._unsafeSupplier = unsafeSupplier;
        }
    }

    protected static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable cause) {
            super(cause);
        }
    }

    protected static class ThrowableHolder {
        private final Throwable _throwable;

        public ThrowableHolder(Throwable throwable) {
            this._throwable = throwable;
        }

        public Throwable getThrowable() {
            return this._throwable;
        }
    }
}

