/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.spring.context.TunnelApplicationContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.DispatcherServlet;

public class RemotingServlet
extends DispatcherServlet {
    public static final String CONTEXT_CLASS = TunnelApplicationContext.class.getName();
    public static final String CONTEXT_CONFIG_LOCATION = "/WEB-INF/remoting-servlet.xml,/WEB-INF/remoting-servlet-ext.xml";
    private static final Log _log = LogFactoryUtil.getLog(RemotingServlet.class);

    public Class<?> getContextClass() {
        try {
            return Class.forName(CONTEXT_CLASS);
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }

    public String getContextConfigLocation() {
        return CONTEXT_CONFIG_LOCATION;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        try {
            AccessControlThreadLocal.setRemoteAccess(true);
            super.service(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess(remoteAccess);
        }
    }
}

