/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.dao.orm.hibernate.FieldInterceptionHelperUtil;
import com.liferay.portal.deploy.hot.CustomJspBagRegistryUtil;
import com.liferay.portal.deploy.hot.ServiceWrapperRegistry;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.servlet.PortalSessionListener;
import com.liferay.portal.spring.aop.DynamicProxyCreator;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.spring.context.PortalApplicationContext;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    private static final Field _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD;
    private static final Log _log;
    private static String _portalServletContextName;
    private static String _portalServletContextPath;
    private ArrayApplicationContext _arrayApplicationContext;
    private ServiceWrapperRegistry _serviceWrapperRegistry;

    public static String getPortalServletContextName() {
        return _portalServletContextName;
    }

    public static String getPortalServletContextPath() {
        return _portalServletContextPath;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ThreadLocalCacheManager.destroy();
        if (this._serviceWrapperRegistry != null) {
            this._serviceWrapperRegistry.close();
        }
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            PortalLifecycleUtil.reset();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this.closeDataSource("counterDataSourceImpl");
        this.closeDataSource("liferayDataSourceImpl");
        super.contextDestroyed(servletContextEvent);
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        try {
            ModuleFrameworkUtilAdapter.stopFramework(PropsValues.MODULE_FRAMEWORK_STOP_WAIT_TIMEOUT);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        ModuleFrameworkUtilAdapter.unregisterContext((Object)this._arrayApplicationContext);
        this._arrayApplicationContext.close();
        ClassLoaderPool.unregister(_portalServletContextName);
        ServletContextClassLoaderPool.unregister(_portalServletContextName);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Class.forName(SystemProperties.class.getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        DBManagerUtil.reset();
        DeployManagerUtil.reset();
        InstancePool.reset();
        MethodKey.resetCache();
        PortalBeanLocatorUtil.reset();
        PortletBagPool.reset();
        FieldInterceptionHelperUtil.initialize();
        ServletContext servletContext = servletContextEvent.getServletContext();
        String portalLibDir = servletContext.getRealPath("/WEB-INF/lib");
        portalLibDir = StringUtil.replace(portalLibDir, '\\', '/');
        if (Validator.isNotNull(portalLibDir)) {
            SystemProperties.set("liferay.lib.portal.dir", portalLibDir);
        }
        PortalClassPathUtil.initializeClassPaths(servletContext);
        InitUtil.init();
        this._logJVMArguments();
        _portalServletContextName = servletContext.getServletContextName();
        if (_portalServletContextName == null) {
            _portalServletContextName = "";
        }
        if (ServerDetector.isJetty() && _portalServletContextName.equals("/")) {
            _portalServletContextName = "";
        }
        _portalServletContextPath = servletContext.getContextPath();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = tempDir.getAbsolutePath();
        try {
            ModuleFrameworkUtilAdapter.initFramework();
            this._arrayApplicationContext = new ArrayApplicationContext(PropsValues.SPRING_INFRASTRUCTURE_CONFIGS);
            servletContext.setAttribute(PortalApplicationContext.PARENT_APPLICATION_CONTEXT, (Object)this._arrayApplicationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        ClassLoaderPool.register(_portalServletContextName, portalClassLoader);
        ServletContextClassLoaderPool.register(_portalServletContextName, portalClassLoader);
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            @Override
            public void dependenciesFulfilled() {
                PortalContextLoaderListener.this._serviceWrapperRegistry = new ServiceWrapperRegistry();
            }

            @Override
            public void destroy() {
            }
        });
        serviceDependencyManager.registerDependencies(MessageBus.class, PortalExecutorManager.class, SchedulerEngineHelper.class, SingleDestinationMessageSenderFactory.class);
        FutureTask<Void> springInitTask = null;
        if (PropsValues.MODULE_FRAMEWORK_CONCURRENT_STARTUP_ENABLED) {
            springInitTask = new FutureTask<Void>(() -> {
                super.contextInitialized(servletContextEvent);
                return null;
            });
            Thread springInitThread = new Thread(springInitTask, "Portal Spring Init Thread");
            springInitThread.setDaemon(true);
            springInitThread.start();
        }
        try {
            ModuleFrameworkUtilAdapter.registerContext((Object)this._arrayApplicationContext);
            ModuleFrameworkUtilAdapter.startFramework();
            ModuleFrameworkUtilAdapter.startRuntime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (springInitTask == null) {
            super.contextInitialized(servletContextEvent);
        } else {
            try {
                springInitTask.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        InitUtil.registerSpringInitialized();
        if (PropsValues.CACHE_CLEAR_ON_CONTEXT_INITIALIZATION) {
            CacheRegistryUtil.clear();
            PortletContextBagPool.clear();
            WebAppPool.clear();
            TemplateResourceLoaderUtil.clearCache();
            ServletContextPool.clear();
            PortalCacheHelperUtil.clearPortalCaches("MULTI_VM_PORTAL_CACHE_MANAGER");
            PortalCacheHelperUtil.clearPortalCaches("SINGLE_VM_PORTAL_CACHE_MANAGER");
        }
        ServletContextPool.put(_portalServletContextName, servletContext);
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator(beanLocatorImpl);
        for (ClassLoader classLoader = portalClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        DynamicProxyCreator dynamicProxyCreator = DynamicProxyCreator.getDynamicProxyCreator();
        dynamicProxyCreator.clear();
        try {
            ModuleFrameworkUtilAdapter.registerContext(applicationContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CustomJspBagRegistryUtil.getCustomJspBags();
        this.initListeners(servletContext);
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    protected void closeDataSource(String name) {
        DataSource dataSource = (DataSource)PortalBeanLocatorUtil.locate(name);
        if (dataSource instanceof Closeable) {
            try {
                Closeable closeable = (Closeable)((Object)dataSource);
                closeable.close();
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator = (ConfigurableApplicationContextConfigurator)this._arrayApplicationContext.getBean("configurableApplicationContextConfigurator", ConfigurableApplicationContextConfigurator.class);
        configurableApplicationContextConfigurator.configure((ConfigurableApplicationContext)configurableWebApplicationContext);
    }

    protected void initListeners(ServletContext servletContext) {
        if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            servletContext.addListener(SerializableSessionAttributeListener.class);
        }
        servletContext.addListener(PortalSessionListener.class);
        servletContext.addListener(PortletSessionListenerManager.class);
    }

    private void _logJVMArguments() {
        if (!_log.isInfoEnabled()) {
            return;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        StringBundler sb = new StringBundler(inputArguments.size() * 2);
        sb.append("JVM arguments: ");
        for (String inputArgument : inputArguments) {
            sb.append(inputArgument);
            sb.append(" ");
        }
        if (!inputArguments.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        _log.info(sb.toString());
    }

    static {
        _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
        _portalServletContextName = "";
        _portalServletContextPath = "/";
        try {
            _FILTERED_PROPERTY_DESCRIPTORS_CACHE_FIELD = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, "filteredPropertyDescriptorsCache");
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError(e);
        }
    }
}

