/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.bean.LiferayBeanFactory;
import java.io.FileNotFoundException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ArrayApplicationContext
extends ClassPathXmlApplicationContext {
    private static final Log _log = LogFactoryUtil.getLog(ArrayApplicationContext.class);

    public ArrayApplicationContext(String[] configLocations) {
        super(configLocations);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new LiferayBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) {
        String[] configLocations = this.getConfigLocations();
        if (configLocations == null) {
            return;
        }
        for (String configLocation : configLocations) {
            try {
                reader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn(cause.getMessage());
                    continue;
                }
                _log.error(e, e);
            }
        }
    }
}

