/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.spring.aop.InvocationHandlerFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.BeanMatcher;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class DynamicProxyCreator
implements BeanPostProcessor,
Ordered {
    private static final DynamicProxyCreator _instance = new DynamicProxyCreator();
    private final List<ObjectValuePair<BeanMatcher, InvocationHandlerFactory>> _beanMatcherInvocationHandlerFactories = new ArrayList<ObjectValuePair<BeanMatcher, InvocationHandlerFactory>>();

    public static DynamicProxyCreator getDynamicProxyCreator() {
        return _instance;
    }

    public void clear() {
        this._beanMatcherInvocationHandlerFactories.clear();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        for (ObjectValuePair<BeanMatcher, InvocationHandlerFactory> objectValuePair : this._beanMatcherInvocationHandlerFactories) {
            BeanMatcher beanMatcher = objectValuePair.getKey();
            if (!beanMatcher.match(beanClass, beanName)) continue;
            InvocationHandlerFactory invocationHandlerFactory = objectValuePair.getValue();
            InvocationHandler invocationHandler = invocationHandlerFactory.createInvocationHandler(bean);
            bean = ProxyUtil.newProxyInstance(contextClassLoader, beanClass.getInterfaces(), invocationHandler);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public static class Register {
        public Register(BeanMatcher beanMatcher, InvocationHandlerFactory invocationHandlerFactory) {
            ObjectValuePair<BeanMatcher, InvocationHandlerFactory> objectValuePair = new ObjectValuePair<BeanMatcher, InvocationHandlerFactory>(beanMatcher, invocationHandlerFactory);
            _instance._beanMatcherInvocationHandlerFactories.add(objectValuePair);
        }
    }
}

