/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.AopInvocationHandler;
import com.liferay.portal.spring.aop.BeanMatcher;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;

public abstract class BaseServiceBeanAutoProxyCreator
implements SmartInstantiationAwareBeanPostProcessor {
    private final BeanMatcher _beanMatcher;
    private final ClassLoader _classLoader;
    private final Set<CacheKey> _earlyProxyReferences = Collections.newSetFromMap(new ConcurrentHashMap());

    public BaseServiceBeanAutoProxyCreator(BeanMatcher beanMatcher, ClassLoader classLoader) {
        this._beanMatcher = beanMatcher;
        this._classLoader = classLoader;
    }

    public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) {
        return null;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        if (!this._beanMatcher.match(beanClass, beanName)) {
            return bean;
        }
        this._earlyProxyReferences.add(new CacheKey(beanClass, beanName));
        return this._createProxy(bean);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        if (!this._beanMatcher.match(beanClass, beanName) || this._earlyProxyReferences.contains(new CacheKey(beanClass, beanName))) {
            return bean;
        }
        return this._createProxy(bean);
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) {
        return true;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) {
        return null;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues propertyValues, PropertyDescriptor[] propertyDescriptors, Object bean, String beanName) {
        return propertyValues;
    }

    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        return null;
    }

    protected abstract AopInvocationHandler createAopInvocationHandler(Object var1);

    private Object _createProxy(Object bean) {
        AopInvocationHandler aopInvocationHandler = this.createAopInvocationHandler(bean);
        return ProxyUtil.newProxyInstance(this._classLoader, ReflectionUtil.getInterfaces(bean), aopInvocationHandler);
    }

    private static class CacheKey {
        private final String _beanName;
        private final Class<?> _clazz;

        public boolean equals(Object obj) {
            CacheKey cacheKey = (CacheKey)obj;
            return this._clazz.equals(cacheKey._clazz) && Objects.equals(this._beanName, cacheKey._beanName);
        }

        public int hashCode() {
            int hash = HashUtil.hash(0, this._clazz);
            return HashUtil.hash(hash, this._beanName);
        }

        private CacheKey(Class<?> clazz, String beanName) {
            this._clazz = clazz;
            this._beanName = beanName;
        }
    }
}

