/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.spring.aop.AopMethodInvocationImpl;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionInterceptor;
import com.liferay.portal.transaction.TransactionsUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AopInvocationHandler
implements InvocationHandler {
    private static final TransactionInterceptor _transactionInterceptor = new TransactionInterceptor();
    private final Map<Method, AopMethodInvocation> _aopMethodInvocations = new ConcurrentHashMap<Method, AopMethodInvocation>();
    private ChainableMethodAdvice[] _chainableMethodAdvices;
    private volatile Object _target;
    private final TransactionExecutor _transactionExecutor;

    public Object getTarget() {
        return this._target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        AopMethodInvocation aopMethodInvocation = this._getAopMethodInvocation(method);
        return aopMethodInvocation.proceed(arguments);
    }

    public synchronized void setTarget(Object target) {
        this._target = target;
        this._aopMethodInvocations.clear();
    }

    protected AopInvocationHandler(Object target, ChainableMethodAdvice[] chainableMethodAdvices, TransactionExecutor transactionExecutor) {
        this._target = target;
        this._chainableMethodAdvices = chainableMethodAdvices;
        this._transactionExecutor = transactionExecutor;
    }

    protected synchronized void reset() {
        this._aopMethodInvocations.clear();
    }

    protected synchronized void setChainableMethodAdvices(ChainableMethodAdvice[] chainableMethodAdvices) {
        this._chainableMethodAdvices = chainableMethodAdvices;
        this._aopMethodInvocations.clear();
    }

    private static AopMethodInvocation _createAopMethodInvocation(Object target, Method method, ChainableMethodAdvice[] chainableMethodAdvices, TransactionExecutor transactionExecutor) {
        Map<Class<? extends Annotation>, Annotation> annotations;
        AopMethodInvocationImpl aopMethodInvocation = null;
        ChainableMethodAdvice nextChainableMethodAdvice = null;
        Class<?> targetClass = target.getClass();
        Object transactionAttributeAdapter = _transactionInterceptor.createMethodContext((Class)targetClass, method, (Map)(annotations = AnnotationLocator.index(method, targetClass)));
        if (transactionAttributeAdapter != null) {
            ((TransactionAttributeAdapter)transactionAttributeAdapter).setTransactionExecutor(transactionExecutor);
            aopMethodInvocation = new AopMethodInvocationImpl(target, method, transactionAttributeAdapter, nextChainableMethodAdvice, aopMethodInvocation);
            nextChainableMethodAdvice = _transactionInterceptor;
        }
        for (int i = chainableMethodAdvices.length - 1; i >= 0; --i) {
            ChainableMethodAdvice chainableMethodAdvice = chainableMethodAdvices[i];
            Object methodContext = chainableMethodAdvice.createMethodContext(targetClass, method, annotations);
            if (methodContext == null) continue;
            aopMethodInvocation = new AopMethodInvocationImpl(target, method, methodContext, nextChainableMethodAdvice, aopMethodInvocation);
            nextChainableMethodAdvice = chainableMethodAdvice;
        }
        return new AopMethodInvocationImpl(target, method, null, nextChainableMethodAdvice, aopMethodInvocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AopMethodInvocation _getAopMethodInvocation(Method method) {
        if (TransactionsUtil.isEnabled()) {
            AopMethodInvocation aopMethodInvocation = this._aopMethodInvocations.get(method);
            if (aopMethodInvocation == null) {
                AopMethodInvocation previousAopMethodInvocation = null;
                AopInvocationHandler aopInvocationHandler = this;
                synchronized (aopInvocationHandler) {
                    aopMethodInvocation = AopInvocationHandler._createAopMethodInvocation(this._target, method, this._chainableMethodAdvices, this._transactionExecutor);
                    previousAopMethodInvocation = this._aopMethodInvocations.putIfAbsent(method, aopMethodInvocation);
                }
                if (previousAopMethodInvocation != null) {
                    aopMethodInvocation = previousAopMethodInvocation;
                }
            }
            return aopMethodInvocation;
        }
        return new AopMethodInvocationImpl(this._target, method, null, null, null);
    }
}

