/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.social;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Date;

public class SocialActivityManagerImpl<T extends ClassedModel & GroupedModel>
implements SocialActivityManager<T> {
    private final SocialActivityManager<T> _defaultSocialActivityManager;
    private final ServiceTrackerMap<String, SocialActivityManager<T>> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(SocialActivityManager.class, "(model.class.name=*)", new ServiceReferenceMapper<String, SocialActivityManager<T>>(){

        @Override
        public void map(ServiceReference<SocialActivityManager<T>> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            String modelClassName = (String)serviceReference.getProperty("model.class.name");
            emitter.emit(modelClassName);
        }
    });

    public SocialActivityManagerImpl(SocialActivityManager<T> defaultSocialActivityManager) {
        this._defaultSocialActivityManager = defaultSocialActivityManager;
    }

    @Override
    public void addActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this.getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addActivity(userId, model, type, extraData, receiverUserId);
    }

    @Override
    public void addUniqueActivity(long userId, Date createDate, T model, int type, String extraData, long receiverUserId) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this.getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addUniqueActivity(userId, createDate, model, type, extraData, receiverUserId);
    }

    @Override
    public void addUniqueActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this.getSocialActivityManager(model.getModelClassName());
        socialActivityManager.addUniqueActivity(userId, model, type, extraData, receiverUserId);
    }

    @Override
    public void deleteActivities(T model) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this.getSocialActivityManager(model.getModelClassName());
        socialActivityManager.deleteActivities(model);
    }

    @Override
    public void updateLastSocialActivity(long userId, T model, int type, Date createDate) throws PortalException {
        SocialActivityManager<T> socialActivityManager = this.getSocialActivityManager(model.getModelClassName());
        socialActivityManager.updateLastSocialActivity(userId, model, type, createDate);
    }

    protected SocialActivityManager<T> getSocialActivityManager(String className) {
        SocialActivityManager<T> socialActivityManager = this._serviceTrackerMap.getService(className);
        if (socialActivityManager != null) {
            return socialActivityManager;
        }
        return this._defaultSocialActivityManager;
    }
}

