/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint.methods;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.sharepoint.Property;
import com.liferay.portal.sharepoint.ResponseElement;
import com.liferay.portal.sharepoint.SharepointException;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.methods.Method;
import java.util.List;

public abstract class BaseMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(BaseMethodImpl.class);

    @Override
    public String getRootPath(SharepointRequest sharepointRequest) {
        return "";
    }

    @Override
    public void process(SharepointRequest sharepointRequest) throws SharepointException {
        try {
            this.doProcess(sharepointRequest);
        }
        catch (Exception e) {
            throw new SharepointException(e);
        }
    }

    protected void doProcess(SharepointRequest sharepointRequest) throws Exception {
        ServletResponseUtil.write(sharepointRequest.getHttpServletResponse(), this.getResponse(sharepointRequest, false));
    }

    protected abstract List<ResponseElement> getElements(SharepointRequest var1) throws Exception;

    protected String getResponse(SharepointRequest sharepointRequest, boolean appendNewline) throws Exception {
        List<ResponseElement> elements = this.getElements(sharepointRequest);
        StringBundler sb = new StringBundler(elements.size() + 9);
        sb.append("<html><head><title>vermeer RPC packet</title></head>");
        sb.append("\n");
        sb.append("<body>");
        sb.append("\n");
        Property property = new Property("method", this.getMethodName() + ":" + "6.0.2.8117");
        sb.append(property.parse());
        for (ResponseElement element : elements) {
            sb.append(element.parse());
        }
        sb.append("</body>");
        sb.append("\n");
        sb.append("</html>");
        if (appendNewline) {
            sb.append("\n");
        }
        String html = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug("Response HTML\n" + html);
        }
        return html;
    }
}

