/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.setup;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang.time.StopWatch;

public class SetupWizardSampleDataUtil {
    private static final Object[][] _ORGANIZATION_ARRAYS = new Object[][]{{"Chicago", 19014L, 19L, "organization", "ORD"}, {"Consulting", 19005L, 19L, "organization"}, {"Dalian", 0L, 2L, "organization", "DLC"}, {"Engineering", 19005L, 19L, "organization"}, {"Frankfurt", 0L, 4L, "organization", "FRA"}, {"Hong Kong", 0L, 2L, "organization", "HKG"}, {"Kuala Lumpur", 0L, 135L, "organization", "KUL"}, {"Los Angeles", 19005L, 19L, "organization", "LAX"}, {"Madrid", 0L, 15L, "organization", "MAD"}, {"Marketing", 19005L, 19L, "organization"}, {"New York", 19033L, 19L, "organization", "NYC"}, {"Saint Paulo", 0L, 48L, "organization", "GRU"}, {"Sales", 19005L, 19L, "organization"}, {"San Francisco", 19005L, 19L, "organization", "SFO"}, {"Support", 19005L, 19L, "organization"}};
    private static final Log _log = LogFactoryUtil.getLog(SetupWizardSampleDataUtil.class);

    public static void addSampleData(long companyId) throws Exception {
        SetupWizardSampleDataUtil.addSampleData(companyId, PropsValues.COMPANY_DEFAULT_NAME, PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME, PropsValues.ADMIN_EMAIL_FROM_ADDRESS, false);
    }

    public static void addSampleData(long companyId, String companyName, String adminUserFirstName, String adminUserLastName, String adminUserEmailAddress, boolean resetPassword) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info("Adding sample data");
        }
        Company company = SetupWizardSampleDataUtil.updateCompany(CompanyLocalServiceUtil.getCompanyById(companyId), companyName, LocaleUtil.toLanguageId(LocaleUtil.getDefault()));
        User adminUser = SetupWizardSampleDataUtil.updateAdminUser(company, LocaleUtil.getDefault(), LocaleUtil.toLanguageId(LocaleUtil.getDefault()), adminUserEmailAddress, adminUserFirstName, adminUserLastName, resetPassword);
        User defaultUser = company.getDefaultUser();
        Account account = company.getAccount();
        Organization organization = OrganizationLocalServiceUtil.addOrganization(defaultUser.getUserId(), 0L, account.getLegalName(), true);
        GroupLocalServiceUtil.updateFriendlyURL(organization.getGroupId(), "/main");
        Layout extranetLayout = LayoutLocalServiceUtil.addLayout(defaultUser.getUserId(), organization.getGroupId(), false, 0L, account.getLegalName() + " Extranet", null, null, "portlet", false, "/extranet", new ServiceContext());
        LayoutLocalServiceUtil.updateLayout(extranetLayout.getGroupId(), false, extranetLayout.getLayoutId(), extranetLayout.getTypeSettings());
        Layout intranetLayout = LayoutLocalServiceUtil.addLayout(defaultUser.getUserId(), organization.getGroupId(), true, 0L, account.getLegalName() + " Intranet", null, null, "portlet", false, "/intranet", new ServiceContext());
        LayoutLocalServiceUtil.updateLayout(intranetLayout.getGroupId(), true, intranetLayout.getLayoutId(), intranetLayout.getTypeSettings());
        OrganizationLocalServiceUtil.addUserOrganization(adminUser.getUserId(), organization);
        SetupWizardSampleDataUtil.addOrganizations(companyName, defaultUser, organization);
        if (_log.isInfoEnabled()) {
            _log.info("Finished adding data in " + stopWatch.getTime() + " ms");
        }
    }

    public static User updateAdminUser(Company company, Locale locale, String languageId, String emailAddress, String firstName, String lastName, boolean resetPassword) throws PortalException {
        ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
        String screenName = GetterUtil.getString(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX, "test");
        try {
            screenName = screenNameGenerator.generate(0L, 0L, emailAddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
        User adminUser = UserLocalServiceUtil.fetchUserByEmailAddress(company.getCompanyId(), emailAddress);
        if (adminUser != null) {
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, null, lastName);
            String greeting = LanguageUtil.format(locale, "welcome-x", (Object)fullName, false);
            Contact contact = adminUser.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(contact.getBirthday());
            int birthdayMonth = birthdayCal.get(2);
            int birthdayDay = birthdayCal.get(5);
            int birthdayYear = birthdayCal.get(1);
            adminUser = UserLocalServiceUtil.updateUser(adminUser.getUserId(), "", "", "", false, adminUser.getReminderQueryQuestion(), adminUser.getReminderQueryAnswer(), screenName, emailAddress, adminUser.getFacebookId(), adminUser.getOpenId(), false, null, languageId, adminUser.getTimeZoneId(), greeting, adminUser.getComments(), firstName, adminUser.getMiddleName(), lastName, contact.getPrefixId(), contact.getSuffixId(), contact.isMale(), birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), contact.getJobTitle(), null, null, null, null, null, new ServiceContext());
        } else {
            User user;
            UserLocalServiceUtil.addDefaultAdminUser(company.getCompanyId(), screenName, emailAddress, locale, firstName, "", lastName);
            adminUser = UserLocalServiceUtil.getUserByEmailAddress(company.getCompanyId(), emailAddress);
            String defaultAdminEmailAddress = PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX + "@" + PropsValues.COMPANY_DEFAULT_WEB_ID;
            if (!emailAddress.equals(defaultAdminEmailAddress) && (user = UserLocalServiceUtil.fetchUserByEmailAddress(company.getCompanyId(), defaultAdminEmailAddress)) != null) {
                UserLocalServiceUtil.updateStatus(user.getUserId(), 5, new ServiceContext());
            }
        }
        return UserLocalServiceUtil.updatePasswordReset(adminUser.getUserId(), resetPassword);
    }

    public static Company updateCompany(Company company, String companyName, String languageId) throws Exception {
        Account account = company.getAccount();
        account.setName(companyName);
        account.setLegalName(companyName + ", Inc.");
        AccountLocalServiceUtil.updateAccount(account);
        User defaultUser = company.getDefaultUser();
        defaultUser.setLanguageId(languageId);
        UserLocalServiceUtil.updateUser(defaultUser);
        return company;
    }

    protected static void addOrganizations(String companyName, User defaultUser, Organization parentOrganization) throws Exception {
        for (Object[] organizationArray : _ORGANIZATION_ARRAYS) {
            String name = companyName + organizationArray[0];
            long regionId = (Long)organizationArray[1];
            long countryId = (Long)organizationArray[2];
            String type = (String)organizationArray[3];
            Organization organization = OrganizationLocalServiceUtil.addOrganization(defaultUser.getUserId(), parentOrganization.getOrganizationId(), name, type, regionId, countryId, ListTypeConstants.ORGANIZATION_STATUS_DEFAULT, "", true, null);
            GroupLocalServiceUtil.updateFriendlyURL(organization.getGroupId(), FriendlyURLNormalizerUtil.normalize("/" + organizationArray[0]));
            if (organizationArray.length <= 4) continue;
            String organizationPrefix = (String)organizationArray[4];
            long[] groupIds = new long[]{organization.getGroupId()};
            long[] organizationIds = new long[]{parentOrganization.getOrganizationId(), organization.getOrganizationId()};
            for (int i = 1; i <= 10; ++i) {
                StringBundler sb = new StringBundler(5);
                String defaultUserEmailAddress = defaultUser.getEmailAddress();
                String[] defaultUserEmailAddressParts = defaultUserEmailAddress.split("@");
                sb.append(defaultUserEmailAddressParts[0]);
                sb.append(".");
                sb.append(organizationPrefix);
                sb.append(".");
                sb.append(i);
                String screenName = sb.toString();
                String emailAddress = screenName + "@" + defaultUserEmailAddressParts[1];
                String lastName = organizationPrefix + " " + i;
                User user = UserLocalServiceUtil.addUser(0L, defaultUser.getCompanyId(), false, "test", "test", false, screenName, emailAddress, 0L, null, LocaleUtil.getDefault(), "Test", null, lastName, 0L, 0L, true, 0, 1, 1970, null, groupIds, organizationIds, null, null, false, new ServiceContext());
                user.setPasswordReset(false);
                user.setAgreedToTermsOfUse(true);
                UserLocalServiceUtil.updateUser(user);
            }
        }
    }
}

