/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.util.CacheFileNameContributor;
import com.liferay.registry.collections.ServiceTrackerCollections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class CacheFileNameGenerator {
    private static final List<CacheFileNameContributor> _cacheFileNameContributors = ServiceTrackerCollections.openList(CacheFileNameContributor.class);

    public static String getCacheFileName(HttpServletRequest httpServletRequest, String cacheName) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(cacheName);
        cacheKeyGenerator.append(HttpUtil.getProtocol(httpServletRequest.isSecure()));
        cacheKeyGenerator.append("_");
        cacheKeyGenerator.append(httpServletRequest.getRequestURI());
        StringBundler queryStringSB = new StringBundler(_cacheFileNameContributors.size() * 4);
        for (CacheFileNameContributor cacheFileNameContributor : _cacheFileNameContributors) {
            String value = cacheFileNameContributor.getParameterValue(httpServletRequest);
            if (value == null) continue;
            queryStringSB.append("_");
            queryStringSB.append(cacheFileNameContributor.getParameterName());
            queryStringSB.append("_");
            queryStringSB.append(value);
        }
        cacheKeyGenerator.append(DigesterUtil.digestBase64("SHA-256", queryStringSB.toString()));
        return CacheFileNameGenerator._sterilizeFileName(String.valueOf(cacheKeyGenerator.finish()));
    }

    private static String _sterilizeFileName(String fileName) {
        return StringUtil.replace(fileName, new char[]{'/', '\\', '+', '='}, new char[]{'_', '_', '-', '_'});
    }
}

