/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.uploadservletrequest;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServletRequestFilter
extends BasePortalFilter {
    public static final String COPY_MULTIPART_STREAM_TO_FILE = UploadServletRequestFilter.class.getName() + "#COPY_MULTIPART_STREAM_TO_FILE";

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String contentType = httpServletRequest.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        long companyId;
        Portlet portlet;
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        int fileSizeThreshold = 0;
        String location = null;
        long maxRequestSize = 0L;
        long maxFileSize = 0L;
        if (Validator.isNotNull(portletId) && (portlet = PortletLocalServiceUtil.getPortletById(companyId = PortalUtil.getCompanyId(httpServletRequest), portletId)) != null) {
            ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
            InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create(portlet, servletContext);
            LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)invokerPortlet.getPortletConfig();
            if (liferayPortletConfig.isCopyRequestParameters() || !liferayPortletConfig.isWARFile()) {
                httpServletRequest.setAttribute(COPY_MULTIPART_STREAM_TO_FILE, (Object)Boolean.FALSE);
            }
            fileSizeThreshold = portlet.getMultipartFileSizeThreshold();
            location = portlet.getMultipartLocation();
            maxRequestSize = portlet.getMultipartMaxRequestSize();
            maxFileSize = portlet.getMultipartMaxFileSize();
        }
        UploadServletRequest uploadServletRequest = PortalUtil.getUploadServletRequest(httpServletRequest, fileSizeThreshold, location, maxRequestSize, maxFileSize);
        try {
            this.processFilter(UploadServletRequestFilter.class.getName(), uploadServletRequest, httpServletResponse, filterChain);
        }
        finally {
            uploadServletRequest.cleanUp();
        }
    }
}

