/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.servletcontextinclude;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import com.liferay.taglib.util.ThemeUtil;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletContextIncludeFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(ServletContextIncludeFilter.class);

    @Override
    public boolean isFilterEnabled() {
        return super.isFilterEnabled() && PropsValues.THEME_JSP_OVERRIDE_ENABLED;
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String uri;
            String portletId;
            Theme theme = this.getTheme(httpServletRequest);
            if (theme == null) {
                return false;
            }
            Boolean strict = (Boolean)httpServletRequest.getAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT");
            if (strict != null && strict.booleanValue()) {
                return false;
            }
            FilterConfig filterConfig = this.getFilterConfig();
            ServletContext servletContext = filterConfig.getServletContext();
            if (theme.resourceExists(servletContext, portletId = ThemeUtil.getPortletId(httpServletRequest), uri = (String)httpServletRequest.getAttribute("INVOKER_FILTER_URI"))) {
                httpServletRequest.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_PATH", (Object)uri);
                httpServletRequest.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_THEME", (Object)theme);
                return true;
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    protected Theme getTheme(HttpServletRequest httpServletRequest) throws Exception {
        String themeId = ParamUtil.getString(httpServletRequest, "themeId");
        if (Validator.isNotNull(themeId)) {
            long companyId = PortalUtil.getCompanyId(httpServletRequest);
            return ThemeLocalServiceUtil.getTheme(companyId, themeId);
        }
        long plid = ParamUtil.getLong(httpServletRequest, "plid");
        if (plid <= 0L) {
            plid = ParamUtil.getLong(httpServletRequest, "p_l_id");
        }
        if (plid > 0L) {
            Layout layout = LayoutLocalServiceUtil.getLayout(plid);
            return layout.getTheme();
        }
        Theme theme = (Theme)httpServletRequest.getAttribute("THEME");
        if (theme != null) {
            return theme;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return themeDisplay.getTheme();
        }
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null) {
            return layoutSet.getTheme();
        }
        return null;
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        Theme theme = (Theme)httpServletRequest.getAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_THEME");
        httpServletRequest.setAttribute("THEME", (Object)theme);
        FilterConfig filterConfig = this.getFilterConfig();
        ServletContext servletContext = filterConfig.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher("/WEB-INF/jsp/_servlet_context_include.jsp");
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

