/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class NonceUtil {
    private static final long _NONCE_CLUSTER_TIMEOUT = GetterUtil.getLong(PropsUtil.get("webdav.nonce.cluster.timeout"), 10000L);
    private static final long _NONCE_EXPIRATION = (long)PropsValues.WEBDAV_NONCE_EXPIRATION * 60000L;
    private static final Log _log = LogFactoryUtil.getLog(NonceUtil.class);
    private static final DelayQueue<NonceDelayed> _nonceDelayQueue = new DelayQueue();
    private static final MethodKey _verifyInLocalNode = new MethodKey(NonceUtil.class, "_verifyInLocalNode", String.class);

    public static String generate(long companyId, String remoteAddress) {
        String companyKey = null;
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById(companyId);
            companyKey = company.getKey();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid companyId " + companyId, e);
        }
        long timestamp = System.currentTimeMillis();
        String nonce = DigesterUtil.digestHex("MD5", remoteAddress, String.valueOf(timestamp), companyKey);
        _nonceDelayQueue.put(new NonceDelayed(nonce));
        return nonce;
    }

    public static boolean verify(String nonce) {
        NonceUtil._cleanUp();
        return NonceUtil._verifyInLocalNode(nonce) || NonceUtil._verifyInCluster(nonce);
    }

    private static void _cleanUp() {
        while (_nonceDelayQueue.poll() != null) {
        }
    }

    private static boolean _verifyInCluster(String nonce) {
        if (!ClusterExecutorUtil.isEnabled()) {
            return false;
        }
        MethodHandler methodHandler = new MethodHandler(_verifyInLocalNode, nonce);
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest(methodHandler, true);
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute(clusterRequest);
        BlockingQueue<ClusterNodeResponse> clusterNodeResponses = futureClusterResponses.getPartialResults();
        try {
            while (!clusterNodeResponses.isEmpty() || !futureClusterResponses.isDone()) {
                ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.poll(_NONCE_CLUSTER_TIMEOUT, TimeUnit.MILLISECONDS);
                if (clusterNodeResponse == null) {
                    _log.error("Timeout waiting for nonce verification in the cluster");
                    return false;
                }
                if (!GetterUtil.getBoolean(clusterNodeResponse.getResult())) continue;
                return true;
            }
        }
        catch (InterruptedException ie) {
            _log.error("Interrupted while waiting for nonce verification in the cluster");
        }
        return false;
    }

    private static boolean _verifyInLocalNode(String nonce) {
        NonceUtil._cleanUp();
        return _nonceDelayQueue.remove(new NonceDelayed(nonce));
    }

    private static class NonceDelayed
    implements Delayed {
        private final long _createTime;
        private final String _nonce;

        public NonceDelayed(String nonce) {
            if (nonce == null) {
                throw new NullPointerException("Nonce is null");
            }
            this._nonce = nonce;
            this._createTime = System.currentTimeMillis();
        }

        @Override
        public int compareTo(Delayed delayed) {
            NonceDelayed nonceDelayed = (NonceDelayed)delayed;
            long result = this._createTime - nonceDelayed._createTime;
            if (result == 0L) {
                return 0;
            }
            if (result > 0L) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            NonceDelayed nonceDelayed = (NonceDelayed)obj;
            return this._nonce.equals(nonceDelayed._nonce);
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            long leftDelayTime = _NONCE_EXPIRATION + this._createTime - System.currentTimeMillis();
            return timeUnit.convert(leftDelayTime, TimeUnit.MILLISECONDS);
        }

        public int hashCode() {
            return this._nonce.hashCode();
        }
    }
}

