/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class BaseAuthFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(BaseAuthFilter.class);
    private boolean _basicAuthEnabled;
    private boolean _digestAuthEnabled;
    private Set<String> _hostsAllowed;
    private boolean _httpsRequired;
    private boolean _usePermissionChecker;

    @Override
    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._basicAuthEnabled = GetterUtil.getBoolean(filterConfig.getInitParameter("basic_auth"));
        this._digestAuthEnabled = GetterUtil.getBoolean(filterConfig.getInitParameter("digest_auth"));
        String propertyPrefix = filterConfig.getInitParameter("portal_property_prefix");
        String[] hostsAllowed = null;
        if (Validator.isNull(propertyPrefix)) {
            hostsAllowed = StringUtil.split(filterConfig.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean(filterConfig.getInitParameter("https.required"));
        } else {
            hostsAllowed = PropsUtil.getArray(propertyPrefix + "hosts.allowed");
            this._httpsRequired = GetterUtil.getBoolean(PropsUtil.get(propertyPrefix + "https.required"));
        }
        this._hostsAllowed = hostsAllowed.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(hostsAllowed));
        this._usePermissionChecker = GetterUtil.getBoolean(filterConfig.getInitParameter("use_permission_checker"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpServletRequest basicAuth(HttpServletRequest httpServletRequest222, HttpServletResponse httpServletResponse) throws Exception {
        Object httpServletRequest222;
        HttpSession session = httpServletRequest222.getSession();
        User user = (User)session.getAttribute("USER");
        if (user != null) {
            ProtectedServletRequest httpServletRequest222 = new ProtectedServletRequest((HttpServletRequest)httpServletRequest222, String.valueOf(user.getUserId()), "BASIC");
            PrincipalThreadLocal.setPassword(PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest222));
            return httpServletRequest222;
        }
        long userId = 0L;
        try {
            userId = HttpAuthManagerUtil.getBasicUserId(httpServletRequest222);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (userId > 0L) {
            HttpServletRequest httpServletRequest222 = this.setCredentials((HttpServletRequest)httpServletRequest222, session, UserLocalServiceUtil.getUser(userId), "BASIC");
            return httpServletRequest222;
        }
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
        HttpAuthManagerUtil.generateChallenge(httpServletRequest222, (HttpServletResponse)httpServletResponse, httpAuthorizationHeader);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HttpServletRequest digestAuth(HttpServletRequest httpServletRequest222, HttpServletResponse httpServletResponse) throws Exception {
        Object httpServletRequest222;
        HttpSession session = httpServletRequest222.getSession();
        User user = (User)session.getAttribute("USER");
        if (user != null) {
            ProtectedServletRequest httpServletRequest222 = new ProtectedServletRequest((HttpServletRequest)httpServletRequest222, String.valueOf(user.getUserId()), "DIGEST");
            PrincipalThreadLocal.setPassword(PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest222));
            return httpServletRequest222;
        }
        long userId = 0L;
        try {
            userId = HttpAuthManagerUtil.getDigestUserId(httpServletRequest222);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (userId > 0L) {
            HttpServletRequest httpServletRequest222 = this.setCredentials((HttpServletRequest)httpServletRequest222, session, UserLocalServiceUtil.getUser(userId), "DIGEST");
            return httpServletRequest222;
        }
        HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
        HttpAuthManagerUtil.generateChallenge(httpServletRequest222, (HttpServletResponse)httpServletResponse, httpAuthorizationHeader);
        return null;
    }

    @Deprecated
    protected void initThreadLocals(HttpServletRequest httpServletRequest) throws Exception {
        HttpSession session = httpServletRequest.getSession();
        User user = (User)session.getAttribute("USER");
        this.initThreadLocals(user);
        PrincipalThreadLocal.setPassword(PortalUtil.getUserPassword(httpServletRequest));
    }

    protected void initThreadLocals(User user) throws Exception {
        CompanyThreadLocal.setCompanyId(user.getCompanyId());
        long userId = user.getUserId();
        PrincipalThreadLocal.setName(userId);
        if (!this._usePermissionChecker) {
            return;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && permissionChecker.getUserId() == userId) {
            return;
        }
        permissionChecker = PermissionCheckerFactoryUtil.create(user);
        PermissionThreadLocal.setPermissionChecker(permissionChecker);
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (AccessControlUtil.isAccessAllowed(httpServletRequest, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Access allowed for " + httpServletRequest.getRemoteAddr());
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn("Access denied for " + httpServletRequest.getRemoteAddr());
            }
            httpServletResponse.sendError(403, "Access denied for " + httpServletRequest.getRemoteAddr());
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug("https is required");
            } else {
                _log.debug("https is not required");
            }
        }
        if (this._httpsRequired && !httpServletRequest.isSecure()) {
            if (_log.isDebugEnabled()) {
                String completeURL = HttpUtil.getCompleteURL(httpServletRequest);
                _log.debug("Securing " + completeURL);
            }
            StringBundler sb = new StringBundler(5);
            sb.append("https://");
            sb.append(httpServletRequest.getServerName());
            sb.append(httpServletRequest.getServletPath());
            String queryString = httpServletRequest.getQueryString();
            if (Validator.isNotNull(queryString)) {
                sb.append("?");
                sb.append(httpServletRequest.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Redirect to " + sb.toString());
            }
            httpServletResponse.sendRedirect(sb.toString());
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("Not securing " + HttpUtil.getCompleteURL(httpServletRequest));
            }
            User user = null;
            try {
                user = PortalUtil.initUser(httpServletRequest);
            }
            catch (NoSuchUserException nsue) {
                if (_log.isDebugEnabled()) {
                    _log.debug(nsue, nsue);
                }
                httpServletResponse.sendRedirect(HttpUtil.getCompleteURL(httpServletRequest));
                return;
            }
            this.initThreadLocals(user);
            if (!user.isDefaultUser()) {
                String authType = ParamUtil.getString(httpServletRequest, "authType");
                if (authType == null) {
                    Company company = PortalUtil.getCompany(httpServletRequest);
                    authType = company.getAuthType();
                }
                httpServletRequest = this.setCredentials(httpServletRequest, httpServletRequest.getSession(), user, authType);
            } else if (this._digestAuthEnabled) {
                httpServletRequest = this.digestAuth(httpServletRequest, httpServletResponse);
            } else if (this._basicAuthEnabled) {
                httpServletRequest = this.basicAuth(httpServletRequest, httpServletResponse);
            }
            if (httpServletRequest != null) {
                Class<?> clazz = this.getClass();
                this.processFilter(clazz.getName(), httpServletRequest, httpServletResponse, filterChain);
            }
        }
    }

    @Deprecated
    protected HttpServletRequest setCredentials(HttpServletRequest httpServletRequest, HttpSession session, long userId, String authType) throws Exception {
        return this.setCredentials(httpServletRequest, session, UserLocalServiceUtil.getUser(userId), authType);
    }

    protected HttpServletRequest setCredentials(HttpServletRequest httpServletRequest, HttpSession session, User user, String authType) throws Exception {
        httpServletRequest = new ProtectedServletRequest((HttpServletRequest)httpServletRequest, String.valueOf(user.getUserId()), authType);
        session.setAttribute("USER", (Object)user);
        PrincipalThreadLocal.setPassword(PortalUtil.getUserPassword(httpServletRequest));
        return httpServletRequest;
    }

    protected void setUsePermissionChecker(boolean usePermissionChecker) {
        this._usePermissionChecker = usePermissionChecker;
    }
}

