/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.i18n;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class I18nFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = I18nFilter.class.getName() + "#SKIP_FILTER";
    private static final Log _log = LogFactoryUtil.getLog(I18nFilter.class);
    private static Set<String> _languageIds;

    public static Set<String> getLanguageIds() {
        return _languageIds;
    }

    public static void setLanguageIds(Set<String> languageIds) {
        _languageIds = new HashSet<String>();
        for (String languageId : languageIds) {
            languageId = languageId.substring(1);
            _languageIds.add(languageId);
        }
        _languageIds = Collections.unmodifiableSet(_languageIds);
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return !this.isAlreadyFiltered(httpServletRequest) && !this.isForwardedByI18nServlet(httpServletRequest) && !this.isWidget(httpServletRequest);
    }

    protected String getDefaultLanguageId(HttpServletRequest httpServletRequest) {
        String defaultLanguageId = this.getSiteDefaultLanguageId(httpServletRequest);
        if (Validator.isNull(defaultLanguageId)) {
            defaultLanguageId = LocaleUtil.toLanguageId(LocaleUtil.getDefault());
        }
        return defaultLanguageId;
    }

    protected String getFriendlyURL(HttpServletRequest httpServletRequest) {
        String[] pathInfoElements;
        String friendlyURL = "";
        String pathInfo = httpServletRequest.getPathInfo();
        if (Validator.isNotNull(pathInfo) && (pathInfoElements = pathInfo.split("/")) != null && pathInfoElements.length > 1) {
            friendlyURL = "/" + pathInfoElements[1];
        }
        return friendlyURL;
    }

    protected String getRedirect(HttpServletRequest httpServletRequest) throws Exception {
        String queryString;
        Group group;
        long companyId;
        Group friendlyURLGroup;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0) {
            return null;
        }
        String method = httpServletRequest.getMethod();
        if (method.equals("POST")) {
            return null;
        }
        String contextPath = PortalUtil.getPathContext();
        String requestURI = httpServletRequest.getRequestURI();
        if (Validator.isNotNull(contextPath) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace(requestURI, "//", "/");
        String i18nLanguageId = this.prependI18nLanguageId(httpServletRequest, PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE);
        if (i18nLanguageId == null) {
            return null;
        }
        Locale locale = LocaleUtil.fromLanguageId(i18nLanguageId);
        if (!LanguageUtil.isAvailableLocale(locale)) {
            return null;
        }
        String i18nPathLanguageId = PortalUtil.getI18nPathLanguageId(locale, i18nLanguageId);
        String i18nPath = "/".concat(i18nPathLanguageId);
        if (requestURI.contains(i18nPath.concat("/"))) {
            return null;
        }
        String redirect = contextPath + i18nPath + requestURI;
        int[] groupFriendlyURLIndex = PortalUtil.getGroupFriendlyURLIndex(requestURI);
        String groupFriendlyURL = "";
        int friendlyURLEnd = 0;
        if (groupFriendlyURLIndex != null) {
            int friendlyURLStart = groupFriendlyURLIndex[0];
            friendlyURLEnd = groupFriendlyURLIndex[1];
            groupFriendlyURL = requestURI.substring(friendlyURLStart, friendlyURLEnd);
        }
        if ((friendlyURLGroup = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId = PortalUtil.getCompanyId(httpServletRequest), groupFriendlyURL)) != null && !LanguageUtil.isAvailableLocale(friendlyURLGroup.getGroupId(), i18nLanguageId)) {
            return null;
        }
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null && !layoutSet.isPrivateLayout() && requestURI.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING) && groupFriendlyURL.equals((group = layoutSet.getGroup()).getFriendlyURL())) {
            redirect = contextPath + i18nPath + requestURI.substring(friendlyURLEnd);
        }
        if (Validator.isNull(queryString = httpServletRequest.getQueryString())) {
            queryString = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull(queryString)) {
            redirect = redirect + "?" + queryString;
        }
        return redirect;
    }

    protected String getRequestedLanguageId(HttpServletRequest httpServletRequest, String userLanguageId) {
        HttpSession session = httpServletRequest.getSession();
        Locale locale = (Locale)session.getAttribute("LOCALE");
        String requestedLanguageId = null;
        if (locale != null) {
            requestedLanguageId = LocaleUtil.toLanguageId(locale);
        }
        if (Validator.isNull(requestedLanguageId)) {
            requestedLanguageId = userLanguageId;
        }
        if (Validator.isNull(requestedLanguageId)) {
            requestedLanguageId = CookieKeys.getCookie(httpServletRequest, "GUEST_LANGUAGE_ID", false);
        }
        return requestedLanguageId;
    }

    protected String getSiteDefaultLanguageId(HttpServletRequest httpServletRequest) {
        String friendlyURL = this.getFriendlyURL(httpServletRequest);
        long companyId = PortalUtil.getCompanyId(httpServletRequest);
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup(companyId, friendlyURL);
            Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale(group.getGroupId());
            return LocaleUtil.toLanguageId(siteDefaultLocale);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe.getMessage(), pe);
            }
            return "";
        }
    }

    protected boolean isAlreadyFiltered(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isForwardedByI18nServlet(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute("I18N_LANGUAGE_ID") != null || httpServletRequest.getAttribute("I18N_PATH") != null;
    }

    protected boolean isWidget(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute("WIDGET") != null;
    }

    protected String prependI18nLanguageId(HttpServletRequest httpServletRequest, int prependFriendlyUrlStyle) {
        User user = (User)httpServletRequest.getAttribute("USER");
        String userLanguageId = null;
        if (user != null) {
            userLanguageId = user.getLanguageId();
        }
        String requestedLanguageId = this.getRequestedLanguageId(httpServletRequest, userLanguageId);
        String defaultLanguageId = this.getDefaultLanguageId(httpServletRequest);
        if (Validator.isNull(requestedLanguageId)) {
            requestedLanguageId = defaultLanguageId;
        }
        if (prependFriendlyUrlStyle == 1) {
            return this.prependIfRequestedLocaleDiffersFromDefaultLocale(defaultLanguageId, requestedLanguageId);
        }
        if (prependFriendlyUrlStyle == 2) {
            if (PropsValues.LOCALE_DEFAULT_REQUEST) {
                return LocaleUtil.toLanguageId(PortalUtil.getLocale(httpServletRequest));
            }
            return requestedLanguageId;
        }
        if (prependFriendlyUrlStyle == 3) {
            if (user != null) {
                if (userLanguageId.equals(requestedLanguageId)) {
                    return null;
                }
                return requestedLanguageId;
            }
            return this.prependIfRequestedLocaleDiffersFromDefaultLocale(defaultLanguageId, requestedLanguageId);
        }
        return null;
    }

    protected String prependIfRequestedLocaleDiffersFromDefaultLocale(String defaultLanguageId, String guestLanguageId) {
        if (defaultLanguageId.equals(guestLanguageId)) {
            return null;
        }
        return guestLanguageId;
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        httpServletRequest.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String redirect = this.getRedirect(httpServletRequest);
        if (redirect == null) {
            this.processFilter(I18nFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Redirect " + redirect);
        }
        httpServletResponse.sendRedirect(redirect);
    }
}

