/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.header;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsValues;
import java.text.Format;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HeaderFilter
extends BasePortalFilter {
    private static final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", LocaleUtil.US, TimeZoneUtil.GMT);
    private static final Set<String> _requestHeaderIgnoreInitParams = SetUtil.fromArray(PropsValues.REQUEST_HEADER_IGNORE_INIT_PARAMS);

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        String value = httpServletRequest.getParameter("t");
        if (Validator.isNull(value)) {
            return -1L;
        }
        return GetterUtil.getLong(value) / 1000L * 1000L;
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        FilterConfig filterConfig = this.getFilterConfig();
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (_requestHeaderIgnoreInitParams.contains(name)) continue;
            this._addHeader(httpServletRequest, httpServletResponse, name, filterConfig.getInitParameter(name));
        }
        long lastModified = this.getLastModified(httpServletRequest);
        if (lastModified > 0L) {
            long ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since");
            httpServletResponse.setDateHeader("Last-Modified", lastModified);
            if (lastModified <= ifModifiedSince) {
                httpServletResponse.setDateHeader("Last-Modified", ifModifiedSince);
                httpServletResponse.setStatus(304);
                return;
            }
        }
        this.processFilter(HeaderFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }

    private void _addHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String name, String value) {
        if (StringUtil.equalsIgnoreCase(name, "Cache-Control")) {
            if (this._isNewSession(httpServletRequest)) {
                String contextPath;
                if (value.contains("public")) {
                    return;
                }
                if (PropsValues.WEB_SERVER_PROXY_LEGACY_MODE && (contextPath = httpServletRequest.getContextPath()).equals(PortalUtil.getPathContext())) {
                    return;
                }
            }
        } else if (StringUtil.equalsIgnoreCase(name, "Expires")) {
            if (this._isNewSession(httpServletRequest)) {
                return;
            }
            if (Validator.isNumber(value)) {
                int seconds = GetterUtil.getInteger(value);
                value = _dateFormat.format(System.currentTimeMillis() + (long)seconds * 1000L);
            }
        }
        httpServletResponse.addHeader(name, value);
    }

    private boolean _isNewSession(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        return session == null || session.isNew();
    }
}

