/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.filters.CacheResponseData;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CacheFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = CacheFilter.class + "SKIP_FILTER";
    private static final int _PATTERN_FRIENDLY = 0;
    private static final int _PATTERN_LAYOUT = 1;
    private static final int _PATTERN_RESOURCE = 2;
    private static final Log _log = LogFactoryUtil.getLog(CacheFilter.class);
    private boolean _includeUserAgent;
    private int _pattern;

    @Override
    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._pattern = GetterUtil.getInteger(filterConfig.getInitParameter("pattern"));
        if (this._pattern != 0 && this._pattern != 1 && this._pattern != 2) {
            _log.error("Cache pattern is invalid");
        }
        this._includeUserAgent = GetterUtil.getBoolean(filterConfig.getInitParameter("includeUserAgent"), PropsValues.CACHE_FILTER_INCLUDE_USER_AGENT);
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.isCacheableRequest(httpServletRequest) && !this.isInclude(httpServletRequest) && !this.isAlreadyFiltered(httpServletRequest);
    }

    protected String getCacheKey(HttpServletRequest httpServletRequest) {
        String url;
        int pos;
        StringBundler sb = new StringBundler(11);
        sb.append(httpServletRequest.getMethod());
        sb.append("#");
        sb.append(httpServletRequest.getRequestURL());
        String queryString = httpServletRequest.getQueryString();
        if (queryString == null && (queryString = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string")) == null && (pos = (url = PortalUtil.getCurrentCompleteURL(httpServletRequest)).indexOf(63)) > -1) {
            queryString = url.substring(pos + 1);
        }
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        sb.append("#");
        String languageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID");
        if (Validator.isNull(languageId)) {
            languageId = LanguageUtil.getLanguageId(httpServletRequest);
        }
        sb.append(languageId);
        if (this._includeUserAgent) {
            String userAgent = GetterUtil.getString(httpServletRequest.getHeader("User-Agent"));
            sb.append("#");
            String userAgentLowerCase = StringUtil.toLowerCase(userAgent);
            sb.append(userAgentLowerCase.hashCode());
        }
        sb.append("#");
        sb.append(BrowserSnifferUtil.acceptsGzip(httpServletRequest));
        return StringUtil.toUpperCase(StringUtil.trim(sb.toString()));
    }

    protected long getPlid(long companyId, String pathInfo, String servletPath, long defaultPlid) {
        if (this._pattern == 1) {
            return defaultPlid;
        }
        if (Validator.isNull(pathInfo) || !pathInfo.startsWith("/")) {
            return 0L;
        }
        String friendlyURL = null;
        int pos = pathInfo.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = pathInfo.substring(0, pos);
        } else if (pathInfo.length() > 1) {
            friendlyURL = pathInfo;
        }
        if (Validator.isNull(friendlyURL)) {
            return 0L;
        }
        long groupId = 0L;
        boolean privateLayout = false;
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup(companyId, friendlyURL);
            groupId = group.getGroupId();
            if (servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING) || servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING)) {
                privateLayout = true;
            } else if (servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING)) {
                privateLayout = false;
            }
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isWarnEnabled()) {
                _log.warn(nsle, nsle);
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to get friendly URL group", e);
            }
            return 0L;
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != pathInfo.length()) {
            friendlyURL = pathInfo.substring(pos);
        }
        if (Validator.isNull(friendlyURL)) {
            try {
                return LayoutLocalServiceUtil.getDefaultPlid(groupId, privateLayout);
            }
            catch (Exception e) {
                _log.warn(e, e);
                return 0L;
            }
        }
        if (friendlyURL.endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
            return layout.getPlid();
        }
        catch (NoSuchLayoutException nsle) {
            _log.warn("Unable to get friendly URL layout", nsle);
            return 0L;
        }
        catch (Exception e) {
            _log.error("Unable to get friendly URL layout", e);
            return 0L;
        }
    }

    protected boolean isAlreadyFiltered(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isCacheableData(long companyId, HttpServletRequest httpServletRequest) {
        try {
            if (this._pattern == 2) {
                return true;
            }
            long plid = this.getPlid(companyId, httpServletRequest.getPathInfo(), httpServletRequest.getServletPath(), ParamUtil.getLong(httpServletRequest, "p_l_id"));
            if (plid <= 0L) {
                return false;
            }
            Layout layout = LayoutLocalServiceUtil.getLayout(plid);
            if (!layout.isTypePortlet()) {
                return false;
            }
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            return layoutTypePortlet.isCacheable();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isCacheableRequest(HttpServletRequest httpServletRequest) {
        String plid;
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (Validator.isNotNull(portletId)) {
            return false;
        }
        if (this._pattern == 0 || this._pattern == 1) {
            long userId = PortalUtil.getUserId(httpServletRequest);
            String remoteUser = httpServletRequest.getRemoteUser();
            if (userId > 0L || Validator.isNotNull(remoteUser)) {
                return false;
            }
        }
        return this._pattern != 1 || !Validator.isNull(plid = ParamUtil.getString(httpServletRequest, "p_l_id"));
    }

    protected boolean isCacheableResponse(BufferCacheServletResponse bufferCacheServletResponse) {
        return bufferCacheServletResponse.getStatus() == 200 && bufferCacheServletResponse.getBufferSize() < PropsValues.CACHE_CONTENT_THRESHOLD_SIZE;
    }

    protected boolean isInclude(HttpServletRequest httpServletRequest) {
        String uri = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        long companyId;
        CacheResponseData cacheResponseData;
        httpServletRequest.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String key = this.getCacheKey(httpServletRequest);
        String pAuth = httpServletRequest.getParameter("p_auth");
        if (Validator.isNotNull(pAuth)) {
            try {
                AuthTokenUtil.checkCSRFToken(httpServletRequest, CacheFilter.class.getName());
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Request is not cacheable " + key + ", invalid token received", pe);
                }
                this.processFilter(CacheFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
                return;
            }
            key = key.replace(StringUtil.toUpperCase(pAuth), "VALID");
        }
        if ((cacheResponseData = CacheUtil.getCacheResponseData(companyId = PortalInstances.getCompanyId(httpServletRequest), key)) == null || !cacheResponseData.isValid()) {
            if (!this._isValidCache(cacheResponseData) || !this.isCacheableData(companyId, httpServletRequest)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Request is not cacheable " + key);
                }
                if (cacheResponseData == null) {
                    if (_log.isInfoEnabled()) {
                        _log.info("Caching request with invalid state " + key);
                    }
                    CacheUtil.putCacheResponseData(companyId, key, new CacheResponseData());
                }
                this.processFilter(CacheFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info("Caching request " + key);
            }
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(httpServletResponse);
            this.processFilter(CacheFilter.class.getName(), httpServletRequest, (HttpServletResponse)bufferCacheServletResponse, filterChain);
            cacheResponseData = new CacheResponseData(bufferCacheServletResponse);
            LastPath lastPath = (LastPath)httpServletRequest.getAttribute("LAST_PATH");
            if (lastPath != null) {
                cacheResponseData.setAttribute("LAST_PATH", lastPath);
            }
            String cacheControl = GetterUtil.getString(bufferCacheServletResponse.getHeader("Cache-Control"));
            if (this.isCacheableResponse(bufferCacheServletResponse) && !cacheControl.contains("no-cache") && this.isCacheableRequest(httpServletRequest)) {
                CacheUtil.putCacheResponseData(companyId, key, cacheResponseData);
            }
        } else {
            LastPath lastPath = (LastPath)cacheResponseData.getAttribute("LAST_PATH");
            if (lastPath != null) {
                HttpSession session = httpServletRequest.getSession();
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        CacheResponseUtil.write(httpServletResponse, cacheResponseData);
    }

    private boolean _isValidCache(CacheResponseData cacheResponseData) {
        return cacheResponseData == null || cacheResponseData.isValid();
    }
}

