/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.autologin;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManagerUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AutoLoginFilter
extends BasePortalFilter {
    private static final String _PATH_CHAT_LATEST = "/-/chat/latest";
    private static final Log _log = LogFactoryUtil.getLog(AutoLoginFilter.class);
    private static final Set<AutoLogin> _autoLogins = new CopyOnWriteArraySet<AutoLogin>();
    private static final ServiceTracker<?, AutoLogin> _serviceTracker;

    protected String getLoginRemoteUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession session, String[] credentials) throws Exception {
        if (credentials == null || credentials.length != 3) {
            return null;
        }
        String jUsername = credentials[0];
        String jPassword = credentials[1];
        if (Validator.isNull(jUsername) || Validator.isNull(jPassword)) {
            return null;
        }
        long userId = GetterUtil.getLong(jUsername);
        if (userId <= 0L) {
            return null;
        }
        User user = UserLocalServiceUtil.fetchUserById(userId);
        if (user == null || user.isLockout()) {
            return null;
        }
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            AuthenticatedSessionManagerUtil.signOutSimultaneousLogins(userId);
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            session = AuthenticatedSessionManagerUtil.renewSession(httpServletRequest, session);
        }
        session.setAttribute("j_username", (Object)jUsername);
        if (GetterUtil.getBoolean(credentials[2])) {
            session.setAttribute("j_password", (Object)jPassword);
        } else {
            session.setAttribute("j_password", (Object)PasswordEncryptorUtil.encrypt(jPassword, user.getPassword()));
            if (PropsValues.SESSION_STORE_PASSWORD) {
                session.setAttribute("USER_PASSWORD", (Object)jPassword);
            }
        }
        session.setAttribute("j_remoteuser", (Object)jUsername);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            String mainPath = PortalUtil.getPathMain();
            String redirect = mainPath.concat("/portal/protected");
            if (PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
                redirect = redirect.concat("?redirect=");
                String autoLoginRedirect = (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                if (Validator.isNull(autoLoginRedirect)) {
                    autoLoginRedirect = PortalUtil.getCurrentCompleteURL(httpServletRequest);
                }
                redirect = redirect.concat(URLCodec.encodeURL(autoLoginRedirect));
            }
            httpServletResponse.sendRedirect(redirect);
        }
        return jUsername;
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        HttpSession session = httpServletRequest.getSession();
        String host = PortalUtil.getHost(httpServletRequest);
        if (PortalInstances.isAutoLoginIgnoreHost(host)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Ignore host " + host);
            }
            this.processFilter(AutoLoginFilter.class.getName(), (HttpServletRequest)httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String contextPath = PortalUtil.getPathContext();
        String path = StringUtil.toLowerCase(httpServletRequest.getRequestURI());
        if (!contextPath.equals("/") && path.contains(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if (PortalInstances.isAutoLoginIgnorePath(path)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Ignore path " + path);
            }
            this.processFilter(AutoLoginFilter.class.getName(), (HttpServletRequest)httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String remoteUser = httpServletRequest.getRemoteUser();
        String jUserName = (String)session.getAttribute("j_username");
        if (!PropsValues.AUTH_LOGIN_DISABLED && remoteUser == null && jUserName == null) {
            for (AutoLogin autoLogin : _autoLogins) {
                try {
                    String[] credentials = autoLogin.login((HttpServletRequest)httpServletRequest, httpServletResponse);
                    String redirect = (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT");
                    if (Validator.isNotNull(redirect)) {
                        httpServletResponse.sendRedirect(redirect);
                        return;
                    }
                    String loginRemoteUser = this.getLoginRemoteUser((HttpServletRequest)httpServletRequest, httpServletResponse, session, credentials);
                    if (loginRemoteUser == null) continue;
                    httpServletRequest = new ProtectedServletRequest((HttpServletRequest)httpServletRequest, loginRemoteUser);
                    if (PropsValues.PORTAL_JAAS_ENABLE) {
                        return;
                    }
                    redirect = !PropsValues.AUTH_FORWARD_BY_LAST_PATH ? "/c" : (String)httpServletRequest.getAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE");
                    if (!Validator.isNotNull(redirect)) continue;
                    httpServletResponse.sendRedirect(redirect);
                    return;
                }
                catch (Exception e) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Current URL ");
                    String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
                    sb.append(currentURL);
                    sb.append(" generates exception: ");
                    sb.append(e.getMessage());
                    if (_log.isInfoEnabled()) {
                        sb.append(" stack: ");
                        sb.append(StackTraceUtil.getStackTrace(e));
                    }
                    if (currentURL.endsWith(_PATH_CHAT_LATEST)) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn(sb.toString());
                        continue;
                    }
                    _log.error(sb.toString());
                }
            }
        }
        this.processFilter(AutoLoginFilter.class.getName(), (HttpServletRequest)httpServletRequest, httpServletResponse, filterChain);
    }

    static {
        Registry registry = RegistryUtil.getRegistry();
        _serviceTracker = registry.trackServices(AutoLogin.class, new AutoLoginServiceTrackerCustomizer());
        _serviceTracker.open();
    }

    private static class AutoLoginServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AutoLogin, AutoLogin> {
        private AutoLoginServiceTrackerCustomizer() {
        }

        @Override
        public AutoLogin addingService(ServiceReference<AutoLogin> serviceReference) {
            if (GetterUtil.getBoolean(serviceReference.getProperty("private.auto.login"))) {
                return null;
            }
            Registry registry = RegistryUtil.getRegistry();
            AutoLogin autoLogin = registry.getService(serviceReference);
            if (autoLogin == null) {
                return null;
            }
            _autoLogins.add(autoLogin);
            return autoLogin;
        }

        @Override
        public void modifiedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
        }

        @Override
        public void removedService(ServiceReference<AutoLogin> serviceReference, AutoLogin autoLogin) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            _autoLogins.remove(autoLogin);
        }
    }
}

