/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.authverifier;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthVerifierFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog(AuthVerifierFilter.class.getName());
    private boolean _guestAllowed = true;
    private final Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;
    private final Map<String, Object> _initParametersMap = new HashMap<String, Object>();

    @Override
    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = filterConfig.getInitParameter(name);
            this._initParametersMap.put(name, value);
        }
        String portalPropertyPrefix = GetterUtil.getString(this._initParametersMap.get("portal_property_prefix"));
        if (Validator.isNotNull(portalPropertyPrefix)) {
            Properties properties = PropsUtil.getProperties(portalPropertyPrefix, true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._initParametersMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this._initParametersMap.containsKey("guest.allowed")) {
            this._guestAllowed = GetterUtil.getBoolean(this._initParametersMap.get("guest.allowed"), true);
            this._initParametersMap.remove("guest.allowed");
        }
        if (this._initParametersMap.containsKey("hosts.allowed")) {
            String[] hostsAllowed;
            String hostsAllowedString = (String)this._initParametersMap.get("hosts.allowed");
            for (String hostAllowed : hostsAllowed = StringUtil.split(hostsAllowedString)) {
                this._hostsAllowed.add(hostAllowed);
            }
            this._initParametersMap.remove("hosts.allowed");
        }
        if (this._initParametersMap.containsKey("https.required")) {
            this._httpsRequired = GetterUtil.getBoolean(this._initParametersMap.get("https.required"));
            this._initParametersMap.remove("https.required");
        }
        if (this._initParametersMap.containsKey("use_permission_checker")) {
            this._initParametersMap.remove("use_permission_checker");
            if (_log.isWarnEnabled()) {
                _log.warn("use_permission_checker is deprecated");
            }
        }
    }

    @Override
    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        if (!this._isAccessAllowed(httpServletRequest, httpServletResponse)) {
            return;
        }
        if (this._isApplySSL(httpServletRequest, httpServletResponse)) {
            return;
        }
        if (this._isCORSPreflightRequest(httpServletRequest)) {
            Class<?> clazz = this.getClass();
            this.processFilter(clazz.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        AccessControlUtil.initAccessControlContext(httpServletRequest, httpServletResponse, this._initParametersMap);
        AuthVerifierResult.State state = AccessControlUtil.verifyRequest();
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
        if (_log.isDebugEnabled()) {
            _log.debug("Auth verifier result " + authVerifierResult);
        }
        if (state == AuthVerifierResult.State.INVALID_CREDENTIALS) {
            if (_log.isDebugEnabled()) {
                _log.debug("Result state does not allow us to continue");
            }
        } else if (state == AuthVerifierResult.State.NOT_APPLICABLE) {
            _log.error("Invalid state " + (Object)((Object)state));
        } else if (!this._guestAllowed && state == AuthVerifierResult.State.UNSUCCESSFUL) {
            if (_log.isDebugEnabled()) {
                _log.debug("Guest is not allowed to access " + httpServletRequest.getRequestURI());
            }
            httpServletResponse.sendError(403, "Authorization required");
        } else if (this._guestAllowed || state == AuthVerifierResult.State.SUCCESS) {
            long userId = authVerifierResult.getUserId();
            AccessControlUtil.initContextUser(userId);
            String authType = MapUtil.getString(accessControlContext.getSettings(), "auth.type");
            ProtectedServletRequest protectedServletRequest = new ProtectedServletRequest(httpServletRequest, String.valueOf(userId), authType);
            accessControlContext.setRequest((HttpServletRequest)protectedServletRequest);
            Class<?> clazz = this.getClass();
            this.processFilter(clazz.getName(), (HttpServletRequest)protectedServletRequest, httpServletResponse, filterChain);
        } else {
            _log.error("Unimplemented state " + (Object)((Object)state));
        }
    }

    private boolean _isAccessAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (AccessControlUtil.isAccessAllowed(httpServletRequest, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Access allowed for " + remoteAddr);
            }
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn("Access denied for " + remoteAddr);
        }
        httpServletResponse.sendError(403, "Access denied for " + remoteAddr);
        return false;
    }

    private boolean _isApplySSL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this._httpsRequired || httpServletRequest.isSecure()) {
            return false;
        }
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL(httpServletRequest);
            _log.debug("Securing " + completeURL);
        }
        StringBundler sb = new StringBundler(5);
        sb.append("https://");
        sb.append(httpServletRequest.getServerName());
        sb.append(httpServletRequest.getServletPath());
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNotNull(queryString)) {
            sb.append("?");
            sb.append(httpServletRequest.getQueryString());
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Redirect to " + sb.toString());
        }
        httpServletResponse.sendRedirect(sb.toString());
        return true;
    }

    private boolean _isCORSPreflightRequest(HttpServletRequest httpServletRequest) {
        return StringUtil.equals(httpServletRequest.getMethod(), "OPTIONS") && Validator.isNotNull(httpServletRequest.getHeader("Origin"));
    }
}

