/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;

public class ServletPaths {
    private static final Log _log = LogFactoryUtil.getLog(ServletPaths.class);
    private final String _resourcePath;
    private final ServletContext _servletContext;

    public static String getParentPath(String resourcePath) {
        int index;
        if (Validator.isNull(resourcePath)) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (resourcePath.charAt(resourcePath.length() - 1) == '/') {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if ((index = resourcePath.lastIndexOf(47)) != -1) {
            resourcePath = resourcePath.substring(0, index);
        }
        return resourcePath;
    }

    public ServletPaths(ServletContext servletContext, String resourcePath) {
        if (servletContext == null) {
            throw new NullPointerException("Servlet context is null");
        }
        if (Validator.isNull(resourcePath)) {
            throw new IllegalArgumentException("Resource path is null");
        }
        this._servletContext = servletContext;
        this._resourcePath = resourcePath;
    }

    public ServletPaths down(String path) {
        String normalizedPath = this._normalizePath(path);
        if (normalizedPath.isEmpty()) {
            return this;
        }
        return new ServletPaths(normalizedPath, this._servletContext);
    }

    public String getContent() {
        try {
            URL resourceURL = this._servletContext.getResource(this._resourcePath);
            if (resourceURL == null) {
                return null;
            }
            URLConnection urlConnection = resourceURL.openConnection();
            return StringUtil.read(urlConnection.getInputStream());
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
            return null;
        }
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    private ServletPaths(String resourcePath, ServletContext servletContext) {
        this._resourcePath = resourcePath;
        this._servletContext = servletContext;
    }

    private String _normalizePath(String path) {
        if (Validator.isNull(path) || "/".equals(path)) {
            return "";
        }
        int index = path.indexOf(63);
        if (index != -1) {
            path = path.substring(0, index);
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if (path.charAt(0) != '/' && this._resourcePath.charAt(this._resourcePath.length() - 1) != '/') {
            path = "/".concat(path);
        }
        if (path.contains("./")) {
            Path downPathObject = Paths.get(this._resourcePath, path);
            downPathObject = downPathObject.normalize();
            path = downPathObject.toString();
            path = path.replace('\\', '/');
        } else {
            path = this._resourcePath.concat(path);
        }
        return path;
    }
}

