/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WidgetServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(WidgetServlet.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String redirect = this.getRedirect(httpServletRequest);
            if (redirect == null || !PortalUtil.isValidResourceId(redirect)) {
                PortalUtil.sendError(404, (Exception)new NoSuchLayoutException(), httpServletRequest, httpServletResponse);
            } else {
                httpServletRequest.setAttribute("WIDGET", (Object)Boolean.TRUE);
                ServletContext servletContext = this.getServletContext();
                RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            PortalUtil.sendError(500, e, httpServletRequest, httpServletResponse);
        }
    }

    protected String getRedirect(HttpServletRequest httpServletRequest) {
        String path = GetterUtil.getString(httpServletRequest.getPathInfo());
        if (Validator.isNull(path)) {
            return null;
        }
        String ppid = ParamUtil.getString(httpServletRequest, "p_p_id");
        int pos = path.indexOf("/-/");
        if (Validator.isNull(ppid) && pos == -1) {
            return null;
        }
        return path;
    }
}

