/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(TunnelServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !permissionChecker.isSignedIn()) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unauthenticated access is forbidden");
            }
            httpServletResponse.setStatus(403);
            return;
        }
        ProtectedClassLoaderObjectInputStream ois = null;
        Thread thread = Thread.currentThread();
        try {
            ois = new ProtectedClassLoaderObjectInputStream((InputStream)httpServletRequest.getInputStream(), thread.getContextClassLoader());
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn(ioe, ioe);
            }
            return;
        }
        Object returnObj = null;
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        try {
            AccessControlThreadLocal.setRemoteAccess(true);
            ObjectValuePair ovp = (ObjectValuePair)ois.readObject();
            MethodHandler methodHandler = (MethodHandler)ovp.getValue();
            if (methodHandler != null) {
                MethodKey methodKey = methodHandler.getMethodKey();
                if (!this.isValidRequest(methodKey.getDeclaringClass())) {
                    return;
                }
                returnObj = methodHandler.invoke();
            }
        }
        catch (InvocationTargetException ite) {
            returnObj = ite.getCause();
            if (!(returnObj instanceof PortalException)) {
                _log.error(ite, ite);
                if (returnObj != null) {
                    Throwable throwable = returnObj;
                    returnObj = new SystemException(throwable.getMessage());
                } else {
                    returnObj = new SystemException();
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess(remoteAccess);
        }
        if (returnObj != null) {
            try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());){
                oos.writeObject(returnObj);
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
                throw ioe;
            }
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PortalUtil.sendError(404, (Exception)new IllegalArgumentException("The GET method is not supported"), httpServletRequest, httpServletResponse);
    }

    protected boolean isValidRequest(Class<?> clazz) {
        String className = clazz.getName();
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

