/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.NullSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class SharedSessionWrapper
implements HttpSession {
    private static final Log _log = LogFactoryUtil.getLog(SharedSessionWrapper.class);
    private static final Map<String, String> _sharedSessionAttributesExcludes = new HashMap<String, String>(){
        {
            for (String name : PropsValues.SESSION_SHARED_ATTRIBUTES_EXCLUDES) {
                this.put(name, name);
            }
        }
    };
    private final HttpSession _portalSession;
    private HttpSession _portletSession;

    public SharedSessionWrapper(HttpSession portalSession, HttpSession portletSession) {
        if (portalSession == null) {
            this._portalSession = new NullSession();
            if (_log.isWarnEnabled()) {
                _log.warn("Wrapped portal session is null");
            }
        } else {
            this._portalSession = portalSession;
        }
        this._portletSession = portletSession;
    }

    public Object getAttribute(String name) {
        HttpSession session = this.getSessionDelegate(name);
        return session.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HttpSession session = this.getSessionDelegate();
        Enumeration namesEnu = session.getAttributeNames();
        if (session == this._portletSession) {
            ArrayList namesList = Collections.list(namesEnu);
            Enumeration portalSessionNamesEnu = this._portalSession.getAttributeNames();
            while (portalSessionNamesEnu.hasMoreElements()) {
                String name = (String)portalSessionNamesEnu.nextElement();
                if (!this.containsSharedAttribute(name)) continue;
                namesList.add(name);
            }
            namesEnu = Collections.enumeration(namesList);
        }
        return namesEnu;
    }

    public long getCreationTime() {
        HttpSession session = this.getSessionDelegate();
        return session.getCreationTime();
    }

    public String getId() {
        HttpSession session = this.getSessionDelegate();
        return session.getId();
    }

    public long getLastAccessedTime() {
        HttpSession session = this.getSessionDelegate();
        return session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        HttpSession session = this.getSessionDelegate();
        return session.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        HttpSession session = this.getSessionDelegate();
        return session.getServletContext();
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        HttpSession session = this.getSessionDelegate();
        return session.getSessionContext();
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        List<String> names = ListUtil.fromEnumeration(this.getAttributeNames());
        return names.toArray(new String[0]);
    }

    public void invalidate() {
        HttpSession session = this.getSessionDelegate();
        session.invalidate();
    }

    public boolean isNew() {
        HttpSession session = this.getSessionDelegate();
        return session.isNew();
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        HttpSession session = this.getSessionDelegate(name);
        session.removeAttribute(name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        HttpSession session = this.getSessionDelegate(name);
        session.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        HttpSession session = this.getSessionDelegate();
        session.setMaxInactiveInterval(maxInactiveInterval);
    }

    protected boolean containsSharedAttribute(String name) {
        for (String sharedName : PropsValues.SESSION_SHARED_ATTRIBUTES) {
            if (!name.startsWith(sharedName)) continue;
            return true;
        }
        return false;
    }

    protected HttpSession getSessionDelegate() {
        if (this._portletSession != null) {
            return this._portletSession;
        }
        return this._portalSession;
    }

    protected HttpSession getSessionDelegate(String name) {
        if (this._portletSession == null) {
            return this._portalSession;
        }
        if (_sharedSessionAttributesExcludes.containsKey(name)) {
            return this._portletSession;
        }
        if (this.containsSharedAttribute(name)) {
            return this._portalSession;
        }
        return this._portletSession;
    }
}

