/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletAdapter
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(ServletAdapter.class);
    private ServiceTracker<Servlet, Servlet> _serviceTracker;

    public void destroy() {
        super.destroy();
        this._serviceTracker.close();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter(StringBundler.concat("(&", config.getInitParameter("filter"), "(objectClass=", Servlet.class.getName(), "))"));
        this._serviceTracker = registry.trackServices(filter, new ServletTrackerCustomizer());
        this._serviceTracker.open();
    }

    protected Servlet getServlet() {
        return this._serviceTracker.getService();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Servlet servlet = this.getServlet();
        if (servlet == null) {
            ServletConfig servletConfig = this.getServletConfig();
            PortalUtil.sendError(503, (Exception)((Object)new ServletException("A servlet matching the filter " + servletConfig.getInitParameter("filter") + " is unavailable")), httpServletRequest, httpServletResponse);
            return;
        }
        servlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private static class ServletTrackerCustomizer
    implements ServiceTrackerCustomizer<Servlet, Servlet> {
        private ServletTrackerCustomizer() {
        }

        @Override
        public Servlet addingService(ServiceReference<Servlet> serviceReference) {
            final Map<String, Object> properties = serviceReference.getProperties();
            ServletConfig servletConfig = new ServletConfig(){

                public String getInitParameter(String name) {
                    return GetterUtil.getString(properties.get(name), null);
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.enumeration(properties.keySet());
                }

                public ServletContext getServletContext() {
                    return ServletContextPool.get(PortalUtil.getServletContextName());
                }

                public String getServletName() {
                    return GetterUtil.getString(properties.get("osgi.http.whiteboard.servlet.name"));
                }
            };
            Registry registry = RegistryUtil.getRegistry();
            Servlet servlet = registry.getService(serviceReference);
            try {
                servlet.init(servletConfig);
            }
            catch (ServletException se) {
                _log.error("Unable to initialize servlet", se);
            }
            return servlet;
        }

        @Override
        public void modifiedService(ServiceReference<Servlet> serviceReference, Servlet service) {
        }

        @Override
        public void removedService(ServiceReference<Servlet> serviceReference, Servlet service) {
            service.destroy();
        }
    }
}

