/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;

public class PortalSessionCreator
extends BasePortalLifecycle {
    private static final Log _log = LogFactoryUtil.getLog(PortalSessionCreator.class);
    private final HttpSession _httpSession;

    public PortalSessionCreator(HttpSession httpSession) {
        this._httpSession = httpSession;
        this.registerPortalLifecycle(2);
    }

    @Deprecated
    public PortalSessionCreator(HttpSessionEvent httpSessionEvent) {
        this(httpSessionEvent.getSession());
    }

    @Override
    protected void doPortalDestroy() {
    }

    @Override
    protected void doPortalInit() {
        block5: {
            if (PropsValues.SESSION_DISABLED) {
                return;
            }
            try {
                PortalSessionContext.put(this._httpSession.getId(), this._httpSession);
            }
            catch (IllegalStateException ise) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn(ise, ise);
            }
        }
        try {
            EventsProcessorUtil.process("servlet.session.create.events", PropsValues.SERVLET_SESSION_CREATE_EVENTS, this._httpSession);
        }
        catch (ActionException ae) {
            _log.error(ae, ae);
        }
    }
}

