/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LanguageServlet
extends HttpServlet {
    private static final String _CONTENT_DISPOSITION = "attachment; filename=language.txt";
    private static final Log _log = LogFactoryUtil.getLog(LanguageServlet.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String value;
        String key;
        Locale locale;
        block10: {
            String[] pathArray;
            String path = httpServletRequest.getPathInfo();
            if (_log.isDebugEnabled()) {
                _log.debug("Path " + path);
            }
            try {
                AuthTokenUtil.checkCSRFToken(httpServletRequest, LanguageServlet.class.getName());
            }
            catch (PortalException pe) {
                _log.error("Invalid authentication token received", pe);
                return;
            }
            if (Validator.isNotNull(path) && path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((pathArray = StringUtil.split(path, '/')).length == 0) {
                _log.error("Language id is not specified");
                return;
            }
            if (pathArray.length == 1) {
                _log.error("Language key is not specified");
                return;
            }
            locale = LocaleUtil.fromLanguageId(pathArray[0]);
            key = pathArray[1];
            Object[] arguments = null;
            if (pathArray.length > 2) {
                arguments = new Object[pathArray.length - 2];
                System.arraycopy(pathArray, 2, arguments, 0, arguments.length);
            }
            value = key;
            try {
                value = ArrayUtil.isEmpty(arguments) ? LanguageUtil.get(locale, key) : LanguageUtil.format(locale, key, arguments);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn(e, e);
            }
        }
        if (!LanguageUtil.isValidLanguageKey(locale, key)) {
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader("Pragma", "no-cache");
        }
        httpServletResponse.setContentType("text/plain; charset=UTF-8");
        httpServletResponse.setHeader("Content-Disposition", _CONTENT_DISPOSITION);
        ServletResponseUtil.write(httpServletResponse, value.getBytes("UTF-8"));
    }
}

