/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.action.JSONServiceAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.struts.JSONAction;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(JSONServlet.class);
    private JSONAction _jsonAction;
    private ClassLoader _pluginClassLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        this._pluginClassLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        this._jsonAction = this.getJSONAction(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        block13: {
            boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
            try {
                AccessControlThreadLocal.setRemoteAccess(true);
                if (this._pluginClassLoader == null) {
                    this._jsonAction.execute(null, httpServletRequest, httpServletResponse);
                    break block13;
                }
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this._pluginClassLoader);
                    this._jsonAction.execute(null, httpServletRequest, httpServletResponse);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            }
            catch (IOException ioe) {
                if (!ServletResponseUtil.isClientAbortException(ioe)) {
                    throw ioe;
                }
            }
            catch (SecurityException se) {
                throw new ServletException((Throwable)se);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            finally {
                AccessControlThreadLocal.setRemoteAccess(remoteAccess);
            }
        }
    }

    protected JSONAction getJSONAction(ServletContext servletContext) {
        JSONServiceAction jsonAction = new JSONServiceAction();
        jsonAction.setServletContext(servletContext);
        return jsonAction;
    }
}

