/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.encryptor.EncryptorException;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Deprecated
public class FriendlyURLServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private String _friendlyURLPathPrefix;
    private int _pathInfoOffset;
    private boolean _private;
    private boolean _user;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean(servletConfig.getInitParameter("private"));
        String proxyPath = PortalUtil.getPathProxy();
        this._user = GetterUtil.getBoolean(servletConfig.getInitParameter("user"));
        this._friendlyURLPathPrefix = this._private ? (this._user ? PortalUtil.getPathFriendlyURLPrivateUser() : PortalUtil.getPathFriendlyURLPrivateGroup()) : PortalUtil.getPathFriendlyURLPublic();
        this._pathInfoOffset = this._friendlyURLPathPrefix.length() - proxyPath.length();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Redirect redirect;
        block11: {
            String pathInfo = this.getPathInfo(httpServletRequest);
            redirect = null;
            try {
                redirect = this.getRedirect(httpServletRequest, pathInfo);
                if (httpServletRequest.getAttribute("LAST_PATH") == null) {
                    httpServletRequest.setAttribute("LAST_PATH", (Object)this.getLastPath(httpServletRequest, pathInfo));
                }
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn(pe, pe);
                }
                if (!(pe instanceof NoSuchGroupException) && !(pe instanceof NoSuchLayoutException)) break block11;
                PortalUtil.sendError(404, (Exception)pe, httpServletRequest, httpServletResponse);
                return;
            }
        }
        if (redirect == null) {
            redirect = new Redirect();
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Redirect " + redirect.getPath());
        }
        if (redirect.isValidForward()) {
            ServletContext servletContext = this.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect.getPath());
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (redirect.isPermanent()) {
            httpServletResponse.setHeader("Location", redirect.getPath());
            httpServletResponse.setStatus(301);
        } else {
            httpServletResponse.sendRedirect(redirect.getPath());
        }
    }

    @Deprecated
    protected String getFriendlyURL(String pathInfo) {
        String friendlyURL = this._friendlyURLPathPrefix;
        if (Validator.isNotNull(pathInfo)) {
            friendlyURL = friendlyURL.concat(pathInfo);
        }
        return friendlyURL;
    }

    protected LastPath getLastPath(HttpServletRequest httpServletRequest, String pathInfo) {
        String lifecycle = ParamUtil.getString(httpServletRequest, "p_p_lifecycle");
        if (lifecycle.equals("1")) {
            return new LastPath(this._friendlyURLPathPrefix, pathInfo);
        }
        return new LastPath(this._friendlyURLPathPrefix, pathInfo, HttpUtil.parameterMapToString(httpServletRequest.getParameterMap()));
    }

    protected String getPathInfo(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        int pos = requestURI.indexOf(";jsessionid=");
        if (pos == -1) {
            return requestURI.substring(this._pathInfoOffset);
        }
        return requestURI.substring(this._pathInfoOffset, pos);
    }

    protected Redirect getRedirect(HttpServletRequest httpServletRequest, String path) throws PortalException {
        long userId;
        long companyId;
        Group group;
        if (path.length() <= 1) {
            return new Redirect();
        }
        String friendlyURL = path;
        int pos = path.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = path.substring(0, pos);
        }
        if ((group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId = PortalInstances.getCompanyId(httpServletRequest), friendlyURL)) == null) {
            String screenName = friendlyURL.substring(1);
            if (this._user || !Validator.isNumber(screenName)) {
                User user = UserLocalServiceUtil.fetchUserByScreenName(companyId, screenName);
                if (user != null) {
                    group = user.getGroup();
                } else if (_log.isWarnEnabled()) {
                    _log.warn("No user exists with friendly URL " + screenName);
                }
            } else {
                long groupId = GetterUtil.getLong(screenName);
                group = GroupLocalServiceUtil.fetchGroup(groupId);
                if (group == null) {
                    User user;
                    if (_log.isDebugEnabled()) {
                        _log.debug("No group exists with friendly URL " + groupId + ". Try fetching by screen name instead.");
                    }
                    if ((user = UserLocalServiceUtil.fetchUserByScreenName(companyId, screenName)) != null) {
                        group = user.getGroup();
                    } else if (_log.isWarnEnabled()) {
                        _log.warn("No user or group exists with friendly URL " + groupId);
                    }
                }
            }
        }
        if (group == null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != path.length()) {
            friendlyURL = path.substring(pos);
        } else {
            httpServletRequest.setAttribute("REDIRECT_TO_DEFAULT_LAYOUT", (Object)Boolean.TRUE);
        }
        HashMap<String, Object> requestContext = new HashMap<String, Object>();
        requestContext.put("request", httpServletRequest);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = ServiceContextFactory.getInstance(httpServletRequest);
            ServiceContextThreadLocal.pushServiceContext(serviceContext);
        }
        Map params = httpServletRequest.getParameterMap();
        try {
            LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = PortalUtil.getLayoutFriendlyURLSeparatorComposite(group.getGroupId(), this._private, friendlyURL, params, requestContext);
            Layout layout = layoutFriendlyURLSeparatorComposite.getLayout();
            httpServletRequest.setAttribute("LAYOUT", (Object)layout);
            Locale locale = PortalUtil.getLocale(httpServletRequest);
            String layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorComposite.getFriendlyURL();
            if (Validator.isNull(layoutFriendlyURLSeparatorCompositeFriendlyURL)) {
                layoutFriendlyURLSeparatorCompositeFriendlyURL = layout.getFriendlyURL(locale);
            }
            if ((pos = layoutFriendlyURLSeparatorCompositeFriendlyURL.indexOf(layoutFriendlyURLSeparatorComposite.getURLSeparator())) != 0) {
                String i18nLanguageId;
                if (pos != -1) {
                    layoutFriendlyURLSeparatorCompositeFriendlyURL = layoutFriendlyURLSeparatorCompositeFriendlyURL.substring(0, pos);
                }
                if (Validator.isNotNull(i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID")) && !LanguageUtil.isAvailableLocale(group.getGroupId(), i18nLanguageId) || !StringUtil.equalsIgnoreCase(layoutFriendlyURLSeparatorCompositeFriendlyURL, layout.getFriendlyURL(locale))) {
                    Locale originalLocale = this.setAlternativeLayoutFriendlyURL(httpServletRequest, layout, layoutFriendlyURLSeparatorCompositeFriendlyURL);
                    String redirect = PortalUtil.getLocalizedFriendlyURL(httpServletRequest, layout, locale, originalLocale);
                    Boolean forcePermanentRedirect = Boolean.TRUE;
                    if (Validator.isNull(i18nLanguageId)) {
                        forcePermanentRedirect = Boolean.FALSE;
                    }
                    return new Redirect(redirect, Boolean.TRUE, forcePermanentRedirect);
                }
            }
        }
        catch (NoSuchLayoutException nsle) {
            List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), this._private, 0L);
            for (Layout layout : layouts) {
                if (!layout.matches(httpServletRequest, friendlyURL)) continue;
                String redirect = PortalUtil.getLayoutActualURL(layout, "/c");
                return new Redirect(redirect);
            }
            throw nsle;
        }
        String actualURL = PortalUtil.getActualURL(group.getGroupId(), this._private, "/c", friendlyURL, params, requestContext);
        String portalURL = PortalUtil.getPortalURL(httpServletRequest);
        if (actualURL.startsWith(portalURL)) {
            actualURL = StringUtil.removeSubstring(actualURL, portalURL);
        }
        if ((userId = PortalUtil.getUserId(httpServletRequest)) > 0L && this._isImpersonated(httpServletRequest, userId)) {
            try {
                Company company = PortalUtil.getCompany(httpServletRequest);
                String encDoAsUserId = Encryptor.encrypt(company.getKeyObj(), String.valueOf(userId));
                actualURL = HttpUtil.setParameter(actualURL, "doAsUserId", encDoAsUserId);
            }
            catch (EncryptorException ee) {
                return new Redirect(actualURL);
            }
        }
        return new Redirect(actualURL);
    }

    @Deprecated
    protected Object[] getRedirect(HttpServletRequest httpServletRequest, String path, String mainPath, Map<String, String[]> params) throws Exception {
        Redirect redirect = this.getRedirect(httpServletRequest, path);
        return new Object[]{redirect.getPath(), redirect.isForce()};
    }

    protected Locale setAlternativeLayoutFriendlyURL(HttpServletRequest httpServletRequest, Layout layout, String friendlyURL) {
        List<LayoutFriendlyURL> layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs(layout.getPlid(), friendlyURL, 0, 1);
        if (layoutFriendlyURLs.isEmpty()) {
            return null;
        }
        LayoutFriendlyURL layoutFriendlyURL = layoutFriendlyURLs.get(0);
        Locale locale = LocaleUtil.fromLanguageId(layoutFriendlyURL.getLanguageId());
        String alternativeLayoutFriendlyURL = PortalUtil.getLocalizedFriendlyURL(httpServletRequest, layout, locale, locale);
        SessionMessages.add(httpServletRequest, "alternativeLayoutFriendlyURL", (Object)alternativeLayoutFriendlyURL);
        PortalMessages.add(httpServletRequest, "jspPath", (Object)"/html/common/themes/layout_friendly_url_redirect.jsp");
        return locale;
    }

    private boolean _isImpersonated(HttpServletRequest httpServletRequest, long userId) {
        HttpSession session = httpServletRequest.getSession();
        Long realUserId = (Long)session.getAttribute("USER_ID");
        return userId != realUserId;
    }

    protected static class Redirect {
        private final boolean _force;
        private final String _path;
        private final boolean _permanent;

        public Redirect() {
            this("/c");
        }

        public Redirect(String path) {
            this(path, false, false);
        }

        public Redirect(String path, boolean force, boolean permanent) {
            this._path = path;
            this._force = force;
            this._permanent = permanent;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)obj;
            return Objects.equals(this.getPath(), redirect.getPath()) && this.isForce() == redirect.isForce() && this.isPermanent() == redirect.isPermanent();
        }

        public String getPath() {
            if (Validator.isNull(this._path)) {
                return "/c";
            }
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash(0, this._path);
            hash = HashUtil.hash(hash, this._force);
            hash = HashUtil.hash(hash, this._permanent);
            return hash;
        }

        public boolean isForce() {
            return this._force;
        }

        public boolean isPermanent() {
            return this._permanent;
        }

        public boolean isValidForward() {
            String path = this.getPath();
            if (!path.startsWith("/c")) {
                return false;
            }
            return !this.isForce();
        }
    }
}

