/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactory;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.servlet.ClassLoaderRequestDispatcherWrapper;
import com.liferay.portal.servlet.DirectRequestDispatcher;
import com.liferay.portal.servlet.DirectServletPathRegisterDispatcher;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DirectRequestDispatcherFactoryImpl
implements DirectRequestDispatcherFactory {
    private static final String _EQUINOX_REQUEST_CLASS_NAME = "org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl";
    private static final Log _log = LogFactoryUtil.getLog(DirectRequestDispatcherFactoryImpl.class);

    @Override
    public RequestDispatcher getRequestDispatcher(ServletContext servletContext, String path) {
        RequestDispatcher requestDispatcher = this.doGetRequestDispatcher(servletContext, path);
        return new ClassLoaderRequestDispatcherWrapper(servletContext, requestDispatcher);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(ServletRequest servletRequest, String path) {
        ServletContext servletContext = (ServletContext)servletRequest.getAttribute("CTX");
        if (servletContext == null) {
            return servletRequest.getRequestDispatcher(path);
        }
        return this.getRequestDispatcher(servletContext, path);
    }

    protected RequestDispatcher doGetRequestDispatcher(ServletContext servletContext, String path) {
        return new IndirectRequestDispatcher(this._getetRequestDispatcher(servletContext, path));
    }

    private RequestDispatcher _getetRequestDispatcher(ServletContext servletContext, String path) {
        Servlet servlet;
        if (!PropsValues.DIRECT_SERVLET_CONTEXT_ENABLED) {
            return servletContext.getRequestDispatcher(path);
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path " + path + " is not relative to context root");
        }
        String contextPath = servletContext.getContextPath();
        String fullPath = contextPath.concat(path);
        String queryString = null;
        int pos = fullPath.indexOf(63);
        if (pos != -1) {
            queryString = fullPath.substring(pos + 1);
            fullPath = fullPath.substring(0, pos);
        }
        if ((servlet = DirectServletRegistryUtil.getServlet(fullPath)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No servlet found for " + fullPath);
            }
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            return new DirectServletPathRegisterDispatcher(path, requestDispatcher);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Servlet found for " + fullPath);
        }
        return new DirectRequestDispatcher(servlet, path, queryString);
    }

    private static class IndirectRequestDispatcher
    implements RequestDispatcher {
        private final RequestDispatcher _requestDispatcher;

        public void forward(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Class<?> clazz = request.getClass();
            if (DirectRequestDispatcherFactoryImpl._EQUINOX_REQUEST_CLASS_NAME.equals(clazz.getName())) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                request = new DirectRequestDispatcherServletRequest(wrapper.getRequest(), wrapper.getServletContext());
            }
            this._requestDispatcher.forward(request, response);
        }

        public void include(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Class<?> clazz = request.getClass();
            if (DirectRequestDispatcherFactoryImpl._EQUINOX_REQUEST_CLASS_NAME.equals(clazz.getName())) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                request = new DirectRequestDispatcherServletRequest(wrapper.getRequest(), wrapper.getServletContext());
            }
            this._requestDispatcher.include(request, response);
        }

        private IndirectRequestDispatcher(RequestDispatcher requestDispatcher) {
            this._requestDispatcher = requestDispatcher;
        }
    }

    private static class DirectRequestDispatcherServletRequest
    extends HttpServletRequestWrapper {
        private final ServletContext _servletContext;

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        private DirectRequestDispatcherServletRequest(ServletRequest request, ServletContext servletContext) {
            super((HttpServletRequest)request);
            this._servletContext = servletContext;
        }
    }

    @Deprecated
    public static interface PACL {
        public RequestDispatcher getRequestDispatcher(ServletContext var1, RequestDispatcher var2);
    }
}

