/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.RequestDispatcherUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_DASH_SUFFIX = "-min.css";
    private static final String _CSS_MINIFIED_DOT_SUFFIX = ".min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_MINIFIED_DASH_SUFFIX = "-min.js";
    private static final String _JAVASCRIPT_MINIFIED_DOT_SUFFIX = ".min.js";
    private static final Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private static final PortalCache<String, byte[][]> _bytesArrayPortalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", ComboServlet.class.getName());
    private static final PortalCache<String, FileContentBag> _fileContentBagPortalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", FileContentBag.class.getName());
    private final Set<String> _protectedParameters = SetUtil.fromArray(new String[]{"b", "browserId", "minifierType", "languageId", "t", "themeId", "zx"});

    public static void clearCache() {
        _bytesArrayPortalCache.removeAll();
        _fileContentBagPortalCache.removeAll();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            this.doService(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            _log.error(e, e);
            PortalUtil.sendError(500, e, httpServletRequest, httpServletResponse);
        }
    }

    protected static String getModulePortletId(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return modulePath.substring(0, index);
        }
        return "90";
    }

    protected static String getResourcePath(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return HttpUtil.removePathParameters(modulePath.substring(index + 1));
        }
        return HttpUtil.removePathParameters(modulePath);
    }

    /*
     * WARNING - void declaration
     */
    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        void var11_26;
        void var8_13;
        LinkedHashSet<String> modulePathsSet = new LinkedHashSet<String>();
        Map<String, String[]> parameterMap = HttpUtil.getParameterMap(httpServletRequest.getQueryString());
        Enumeration<String> enu = Collections.enumeration(parameterMap.keySet());
        while (enu.hasMoreElements()) {
            String pathProxy;
            ServletContext servletContext;
            String string;
            String name = enu.nextElement();
            if (this._protectedParameters.contains(name)) continue;
            if ((name = HttpUtil.decodePath(name)).startsWith(string = (servletContext = this.getServletContext()).getContextPath())) {
                name = name.replaceFirst(string, "");
            }
            if (name.startsWith(pathProxy = PortalUtil.getPathProxy())) {
                name = name.replaceFirst(pathProxy, "");
            }
            modulePathsSet.add(name);
        }
        if (modulePathsSet.isEmpty()) {
            PortalUtil.sendError(404, (Exception)new NoSuchLayoutException("Query string translates to an empty module paths set"), httpServletRequest, httpServletResponse);
            return;
        }
        Object[] modulePaths = modulePathsSet.toArray(new String[0]);
        String extension = "";
        for (String string : modulePaths) {
            String pathExtension = this._getModulePathExtension(string);
            if (Validator.isNull(pathExtension)) continue;
            if (Validator.isNull(extension)) {
                extension = pathExtension;
            }
            if (extension.equals(pathExtension)) continue;
            httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
            httpServletResponse.setStatus(400);
            return;
        }
        String string = ParamUtil.getString(httpServletRequest, "minifierType");
        if (Validator.isNull(string)) {
            String string2 = "js";
            if (StringUtil.equalsIgnoreCase(extension, _CSS_EXTENSION)) {
                String string3 = _CSS_EXTENSION;
            }
        }
        if (!var8_13.equals(_CSS_EXTENSION) && !var8_13.equals("js")) {
            String string4 = "js";
        }
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            modulePathsString = modulePathsString + "#" + LanguageUtil.getLanguageId(httpServletRequest);
            bytesArray = _bytesArrayPortalCache.get(modulePathsString);
        }
        if (bytesArray == null) {
            void var11_23;
            bytesArray = new byte[modulePaths.length][];
            boolean bl = false;
            while (var11_23 < modulePaths.length) {
                Object modulePath = modulePaths[var11_23];
                if (!this.validateModuleExtension((String)modulePath)) {
                    httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    httpServletResponse.setStatus(400);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    void var8_15;
                    RequestDispatcher requestDispatcher = this.getResourceRequestDispatcher(httpServletRequest, httpServletResponse, (String)modulePath);
                    if (requestDispatcher == null) {
                        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        httpServletResponse.setStatus(404);
                        return;
                    }
                    bytes = this.getResourceContent(requestDispatcher, httpServletRequest, httpServletResponse, (String)modulePath, (String)var8_15);
                }
                bytesArray[var11_23] = bytes;
                ++var11_23;
            }
            if (modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                _bytesArrayPortalCache.put(modulePathsString, (byte[][])bytesArray);
            }
        }
        String string5 = "text/javascript";
        if (StringUtil.equalsIgnoreCase(extension, _CSS_EXTENSION)) {
            String string6 = "text/css";
        }
        httpServletResponse.setContentType((String)var11_26);
        ServletResponseUtil.write(httpServletResponse, bytesArray);
    }

    protected byte[] getResourceContent(RequestDispatcher requestDispatcher, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String modulePath, String minifierType) throws Exception {
        String portletId;
        Portlet portlet;
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!resourcePath.startsWith((portlet = PortletLocalServiceUtil.getPortletById(portletId = ComboServlet.getModulePortletId(modulePath))).getContextPath())) {
            resourcePath = portlet.getContextPath() + resourcePath;
        }
        StringBundler sb = new StringBundler(5);
        sb.append(resourcePath);
        sb.append("?");
        sb.append(minifierType);
        sb.append("&languageId=");
        sb.append(ParamUtil.getString(httpServletRequest, "languageId"));
        String fileContentKey = sb.toString();
        FileContentBag fileContentBag = _fileContentBagPortalCache.get(fileContentKey);
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (requestDispatcher != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && RequestDispatcherUtil.getLastModifiedTime(requestDispatcher, httpServletRequest, httpServletResponse) == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            _fileContentBagPortalCache.remove(fileContentKey);
        }
        if (requestDispatcher == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            ObjectValuePair<String, Long> objectValuePair = RequestDispatcherUtil.getContentAndLastModifiedTime(requestDispatcher, httpServletRequest, httpServletResponse);
            String stringFileContent = objectValuePair.getKey();
            if (!(StringUtil.endsWith(resourcePath, _CSS_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith(resourcePath, _CSS_MINIFIED_DOT_SUFFIX) || StringUtil.endsWith(resourcePath, _JAVASCRIPT_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith(resourcePath, _JAVASCRIPT_MINIFIED_DOT_SUFFIX))) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    try {
                        stringFileContent = DynamicCSSUtil.replaceToken(this.getServletContext(), httpServletRequest, stringFileContent);
                    }
                    catch (Exception e) {
                        _log.error("Unable to replace tokens in CSS " + resourcePath, e);
                        if (_log.isDebugEnabled()) {
                            _log.debug(stringFileContent);
                        }
                        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    String baseURL = "";
                    int slashIndex = resourcePath.lastIndexOf(47);
                    if (slashIndex != -1) {
                        baseURL = resourcePath.substring(0, slashIndex + 1);
                    }
                    stringFileContent = AggregateUtil.updateRelativeURLs(stringFileContent, baseURL);
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(resourcePath, stringFileContent);
                    stringFileContent = stringFileContent.concat("\n");
                }
            } else if (StringUtil.endsWith(resourcePath, _JAVASCRIPT_MINIFIED_DASH_SUFFIX) || StringUtil.endsWith(resourcePath, _JAVASCRIPT_MINIFIED_DOT_SUFFIX)) {
                stringFileContent = stringFileContent.concat("\n");
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), objectValuePair.getValue());
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            _fileContentBagPortalCache.put(fileContentKey, fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected RequestDispatcher getResourceRequestDispatcher(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String modulePath) throws Exception {
        String portletId = ComboServlet.getModulePortletId(modulePath);
        Portlet portlet = PortletLocalServiceUtil.getPortletById(portletId);
        if (portlet == null || portlet.isUndeployedPortlet()) {
            return null;
        }
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!PortalUtil.isValidResourceId(resourcePath)) {
            if (_log.isWarnEnabled()) {
                _log.warn(StringBundler.concat("Invalid resource ", httpServletRequest.getRequestURL(), "?", httpServletRequest.getQueryString()));
            }
            return null;
        }
        PortletApp portletApp = portlet.getPortletApp();
        ServletContext servletContext = portletApp.getServletContext();
        return servletContext.getRequestDispatcher(resourcePath);
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        String[] fileExtensions;
        int index = (moduleName = ComboServlet.getResourcePath(moduleName)).indexOf(63);
        if (index != -1) {
            moduleName = moduleName.substring(0, index);
        }
        boolean validModuleExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith(moduleName, fileExtension)) continue;
            validModuleExtension = true;
            break;
        }
        return validModuleExtension;
    }

    private String _getModulePathExtension(String modulePath) {
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        int index = resourcePath.indexOf(63);
        if (index != -1) {
            resourcePath = resourcePath.substring(0, index);
        }
        return FileUtil.getExtension(resourcePath);
    }

    private static class FileContentBag
    implements Serializable {
        private final byte[] _fileContent;
        private final long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

