/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.BrowserMetadata;
import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;

public class BrowserSnifferImpl
implements BrowserSniffer {
    protected static String[] revisionLeadings = new String[]{"rv", "it", "ra", "trident", "ie"};
    protected static char[] revisionSeparators = new char[]{'\\', ':', '/', ' '};
    protected static String[] versionLeadings = new String[]{"edge", "chrome", "firefox", "version", "minefield", "trident"};
    protected static char[] versionSeparators = new char[]{'\\', '/'};

    @Override
    public boolean acceptsGzip(HttpServletRequest httpServletRequest) {
        String acceptEncoding = httpServletRequest.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.contains("gzip");
    }

    @Override
    public String getBrowserId(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        if (browserMetadata.isEdge()) {
            return "edge";
        }
        if (browserMetadata.isIe()) {
            return "ie";
        }
        if (browserMetadata.isFirefox()) {
            return "firefox";
        }
        return "other";
    }

    @Override
    public BrowserMetadata getBrowserMetadata(HttpServletRequest httpServletRequest) {
        return new BrowserMetadata(this.getUserAgent(httpServletRequest));
    }

    @Override
    public float getMajorVersion(HttpServletRequest httpServletRequest) {
        return GetterUtil.getFloat(this.getVersion(httpServletRequest));
    }

    @Override
    public String getRevision(HttpServletRequest httpServletRequest) {
        String revision = (String)httpServletRequest.getAttribute("BROWSER_SNIFFER_REVISION");
        if (revision != null) {
            return revision;
        }
        revision = BrowserSnifferImpl.parseVersion(this.getUserAgent(httpServletRequest), revisionLeadings, revisionSeparators);
        httpServletRequest.setAttribute("BROWSER_SNIFFER_REVISION", (Object)revision);
        return revision;
    }

    @Override
    public String getVersion(HttpServletRequest httpServletRequest) {
        String version = (String)httpServletRequest.getAttribute("BROWSER_SNIFFER_VERSION");
        if (version != null) {
            return version;
        }
        String userAgent = this.getUserAgent(httpServletRequest);
        version = BrowserSnifferImpl.parseVersion(userAgent, versionLeadings, versionSeparators);
        if (version.isEmpty()) {
            version = BrowserSnifferImpl.parseVersion(userAgent, revisionLeadings, revisionSeparators);
        }
        httpServletRequest.setAttribute("BROWSER_SNIFFER_VERSION", (Object)version);
        return version;
    }

    @Override
    public boolean isAir(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isAir();
    }

    @Override
    public boolean isAndroid(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isAndroid();
    }

    @Override
    public boolean isChrome(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isChrome();
    }

    @Override
    public boolean isEdge(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isEdge();
    }

    @Override
    public boolean isFirefox(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isFirefox();
    }

    @Override
    public boolean isGecko(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isGecko();
    }

    @Override
    public boolean isIe(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIe();
    }

    @Override
    public boolean isIeOnWin32(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIeOnWin32();
    }

    @Override
    public boolean isIeOnWin64(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIeOnWin64();
    }

    @Override
    public boolean isIphone(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isIphone();
    }

    @Override
    public boolean isLinux(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isLinux();
    }

    @Override
    public boolean isMac(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMac();
    }

    @Override
    public boolean isMobile(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMobile();
    }

    @Override
    public boolean isMozilla(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isMozilla();
    }

    @Override
    public boolean isOpera(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isOpera();
    }

    @Override
    public boolean isRtf(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isRtf(this.getVersion(httpServletRequest));
    }

    @Override
    public boolean isSafari(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isSafari();
    }

    @Override
    public boolean isSun(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isSun();
    }

    @Override
    public boolean isWebKit(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isWebKit();
    }

    @Override
    public boolean isWindows(HttpServletRequest httpServletRequest) {
        BrowserMetadata browserMetadata = this.getBrowserMetadata(httpServletRequest);
        return browserMetadata.isWindows();
    }

    protected static String parseVersion(String userAgent, String[] leadings, char[] separators) {
        for (String leading : leadings) {
            int index = 0;
            while ((index = userAgent.indexOf(leading, index)) >= 0 && (index += leading.length()) + 2 <= userAgent.length()) {
                char c2;
                char c1 = userAgent.charAt(index);
                if (((c2 = userAgent.charAt(++index)) < '0' || c2 > '9') && c2 != '.') continue;
                for (char separator : separators) {
                    if (c1 != separator) {
                        continue;
                    }
                    int majorStart = index;
                    int majorEnd = index + 1;
                    for (int i = majorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        majorEnd = i;
                        break;
                    }
                    String major = userAgent.substring(majorStart, majorEnd);
                    if (userAgent.charAt(majorEnd) != '.') {
                        return major;
                    }
                    int minorStart = majorEnd + 1;
                    int minorEnd = userAgent.length();
                    for (int i = minorStart; i < userAgent.length(); ++i) {
                        char c = userAgent.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        minorEnd = i;
                        break;
                    }
                    String minor = userAgent.substring(minorStart, minorEnd);
                    String version = major.concat(".").concat(minor);
                    if (leading.equals("trident")) {
                        if (version.equals("7.0")) {
                            version = "11.0";
                        } else if (version.equals("6.0")) {
                            version = "10.0";
                        } else if (version.equals("5.0")) {
                            version = "9.0";
                        } else if (version.equals("4.0")) {
                            version = "8.0";
                        }
                    }
                    return version;
                }
            }
        }
        return "";
    }

    protected String getAccept(HttpServletRequest httpServletRequest) {
        String accept = "";
        if (httpServletRequest == null) {
            return accept;
        }
        accept = String.valueOf(httpServletRequest.getAttribute("ACCEPT"));
        if (Validator.isNotNull(accept)) {
            return accept;
        }
        accept = httpServletRequest.getHeader("ACCEPT");
        accept = accept != null ? StringUtil.toLowerCase(accept) : "";
        httpServletRequest.setAttribute("ACCEPT", (Object)accept);
        return accept;
    }

    protected String getUserAgent(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return "";
        }
        Object userAgentObject = httpServletRequest.getAttribute("User-Agent");
        if (userAgentObject != null) {
            return userAgentObject.toString();
        }
        String userAgent = httpServletRequest.getHeader("User-Agent");
        userAgent = userAgent != null ? StringUtil.toLowerCase(userAgent) : "";
        httpServletRequest.setAttribute("User-Agent", (Object)userAgent);
        return userAgent;
    }

    @Deprecated
    protected boolean isIe(String userAgent) {
        BrowserMetadata browserMetadata = new BrowserMetadata(userAgent);
        return browserMetadata.isIe();
    }
}

