/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.atom.AtomProvider;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;

public class AtomServlet
extends AbderaServlet {
    protected Provider createProvider() {
        AtomProvider atomProvider = new AtomProvider();
        atomProvider.init(this.getAbdera(), null);
        List<AtomCollectionAdapter<?>> atomCollectionAdapters = AtomCollectionAdapterRegistryUtil.getAtomCollectionAdapters();
        for (AtomCollectionAdapter<?> atomCollectionAdapter : atomCollectionAdapters) {
            atomProvider.addCollection(atomCollectionAdapter);
        }
        return atomProvider;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        try {
            AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
            AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
            User user = UserLocalServiceUtil.getUser(authVerifierResult.getUserId());
            AtomUtil.saveUserInRequest(httpServletRequest, user);
            AccessControlThreadLocal.setRemoteAccess(true);
            super.service(httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            AccessControlThreadLocal.setRemoteAccess(remoteAccess);
        }
    }
}

