/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CyclicBarrier;

public class SynchronousInvocationHandler
implements InvocationHandler {
    private static final ThreadLocal<Boolean> _synchronizeThreadLocal = new InheritableThreadLocal<Boolean>();
    private final CyclicBarrier _cyclicBarrier;
    private final Method _syncMethod;
    private final Object _target;

    public static void disable() {
        _synchronizeThreadLocal.remove();
    }

    public static void enable() {
        _synchronizeThreadLocal.set(Boolean.TRUE);
    }

    public SynchronousInvocationHandler(int syncCount, Runnable syncRunnable, Method syncMethod, Object target) {
        this._syncMethod = syncMethod;
        this._target = target;
        this._cyclicBarrier = new CyclicBarrier(syncCount, syncRunnable);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (_synchronizeThreadLocal.get() == Boolean.TRUE && this._syncMethod.equals(method)) {
            this._cyclicBarrier.await();
        }
        return method.invoke(this._target, args);
    }
}

