/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.test;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.test.PortalRegisterTestUtil;
import com.liferay.portal.tools.DBUpgrader;
import com.liferay.portal.util.PortalInstances;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ServiceTestUtil {
    public static final int RETRY_COUNT = 10;
    public static final int THREAD_COUNT = 10;
    private static final Log _log = LogFactoryUtil.getLog(ServiceTestUtil.class);
    private static final MessageBus _messageBusWrapper = (MessageBus)ProxyUtil.newProxyInstance(MessageBus.class.getClassLoader(), new Class[]{MessageBus.class}, new InvocationHandler(){
        private final MessageBus _messageBus = MessageBusUtil.getMessageBus();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Objects.equals(method.getName(), "shutdown") && args.length == 1) {
                args[0] = Boolean.FALSE;
            }
            return method.invoke((Object)this._messageBus, args);
        }
    });
    private static final PortalExecutorManager _portalExecutorManagerWrapper = (PortalExecutorManager)ProxyUtil.newProxyInstance(PortalExecutorManager.class.getClassLoader(), new Class[]{PortalExecutorManager.class}, new PortalExecutorManagerInvocationHandler());

    public static void initMainServletServices() {
        try {
            DBUpgrader.upgrade();
        }
        catch (Throwable t) {
            _log.error(t, t);
        }
        MessageBusUtil messageBusUtil = new MessageBusUtil();
        messageBusUtil.setSynchronousMessageSenderMode(SynchronousMessageSender.Mode.DEFAULT);
        ServiceDependencyManager schedulerServiceDependencyManager = new ServiceDependencyManager();
        schedulerServiceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            @Override
            public void dependenciesFulfilled() {
                try {
                    SchedulerEngineHelperUtil.start();
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }

            @Override
            public void destroy() {
            }
        });
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=com.liferay.portal.scheduler.quartz.internal.QuartzSchemaManager)");
        schedulerServiceDependencyManager.registerDependencies(new Class[]{SchedulerEngineHelper.class}, new Filter[]{filter});
        try {
            DBUpgrader.verify();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public static void initPermissions() {
        try {
            PortalInstances.addCompanyId(TestPropsValues.getCompanyId());
            ServiceTestUtil.setUser(TestPropsValues.getUser());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public static void initServices() {
        ServiceTestUtil._setThreadLocals();
        try {
            SearchEngineHelperUtil.initialize(TestPropsValues.getCompanyId());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public static void initStaticServices() {
        PortalRegisterTestUtil.registerIndexers();
        if (TestPropsValues.DL_FILE_ENTRY_PROCESSORS_TRIGGER_SYNCHRONOUSLY) {
            ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
            Filter audioProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_audio_processor");
            Filter imageProcessFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_image_processor");
            Filter pdfProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_pdf_processor");
            Filter rawMetaDataProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_raw_metadata_processor");
            Filter videoProcessorFilter = ServiceTestUtil._registerDestinationFilter("liferay/document_library_video_processor");
            serviceDependencyManager.registerDependencies(audioProcessorFilter, imageProcessFilter, pdfProcessorFilter, rawMetaDataProcessorFilter, videoProcessorFilter);
            serviceDependencyManager.waitForDependencies();
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_audio_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_image_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_pdf_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_raw_metadata_processor");
            ServiceTestUtil._replaceWithSynchronousDestination("liferay/document_library_video_processor");
        }
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> messageBusProperties = new HashMap<String, Object>();
        messageBusProperties.put("service.ranking", Integer.MAX_VALUE);
        registry.registerService(MessageBus.class, _messageBusWrapper, messageBusProperties);
        if (MessageBusUtil.getMessageBus() != _messageBusWrapper) {
            throw new IllegalStateException("MessageBus should be set");
        }
        HashMap<String, Object> portalExecutorManagerProperties = new HashMap<String, Object>();
        portalExecutorManagerProperties.put("service.ranking", Integer.MAX_VALUE);
        registry.registerService(PortalExecutorManager.class, _portalExecutorManagerWrapper, portalExecutorManagerProperties);
        ServiceTestUtil._checkClassNames();
        try {
            ServiceTestUtil._checkResourceActions();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        PortalRegisterTestUtil.registerWorkflowHandlers();
        if (!ArrayUtil.contains(PortalInstances.getWebIds(), TestPropsValues.COMPANY_WEB_ID)) {
            try {
                CompanyLocalServiceUtil.checkCompany(TestPropsValues.COMPANY_WEB_ID);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public static Date newDate() throws Exception {
        return new Date();
    }

    public static Date newDate(int month, int day, int year) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(1, year);
        return calendar.getTime();
    }

    public static void setUser(User user) throws Exception {
        if (user == null) {
            return;
        }
        PrincipalThreadLocal.setName(user.getUserId());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        PermissionThreadLocal.setPermissionChecker(permissionChecker);
    }

    private static void _checkClassNames() {
        PortalUtil.getClassNameId(LiferayRepository.class.getName());
    }

    private static void _checkResourceActions() throws Exception {
        for (int i = 0; i < 200; ++i) {
            String portletId = String.valueOf(i);
            PortletImpl portlet = new PortletImpl();
            portlet.setPortletId(portletId);
            portlet.setPortletModes(new HashMap<String, Set<String>>());
            ResourceActionsUtil.check(portletId);
        }
    }

    private static Filter _registerDestinationFilter(String destinationName) {
        Registry registry = RegistryUtil.getRegistry();
        return registry.getFilter(StringBundler.concat("(&(destination.name=", destinationName, ")(objectClass=", Destination.class.getName(), "))"));
    }

    private static void _replaceWithSynchronousDestination(String name) {
        SynchronousDestination baseDestination = new SynchronousDestination();
        baseDestination.setName(name);
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        Destination oldDestination = messageBus.getDestination(name);
        messageBus.replace(baseDestination, false);
        ThreadPoolExecutor executorService = PortalExecutorManagerUtil.getPortalExecutor(oldDestination.getName());
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(TestPropsValues.CI_TEST_TIMEOUT_TIME, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Destination " + oldDestination.getName() + " shutdown timeout");
            }
        }
        catch (InterruptedException ie) {
            ReflectionUtil.throwException(ie);
        }
    }

    private static void _setThreadLocals() {
        LocaleThreadLocal.setThemeDisplayLocale(new Locale("en", "US"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setPathMain("path");
        serviceContext.setPortalURL("http://tests:8080");
        ServiceContextThreadLocal.pushServiceContext(serviceContext);
    }

    private static class PortalExecutorManagerInvocationHandler
    implements InvocationHandler {
        private final PortalExecutorManager _portalExecutorManager;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!Objects.equals(method.getName(), "shutdown") || args.length != 1) {
                return method.invoke((Object)this._portalExecutorManager, args);
            }
            Map threadPoolExecutors = (Map)ReflectionTestUtil.getFieldValue(this._portalExecutorManager, "_executorServices");
            for (Map.Entry entry : threadPoolExecutors.entrySet()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)entry.getValue();
                threadPoolExecutor.shutdown();
                try {
                    if (threadPoolExecutor.awaitTermination(TestPropsValues.CI_TEST_TIMEOUT_TIME, TimeUnit.MILLISECONDS)) continue;
                    throw new TimeoutException("Thread pool executor " + (String)entry.getKey() + " termination waiting timeout");
                }
                catch (InterruptedException ie) {
                    ReflectionUtil.throwException(ie);
                }
            }
            return null;
        }

        private PortalExecutorManagerInvocationHandler() {
            Registry registry = RegistryUtil.getRegistry();
            this._portalExecutorManager = (PortalExecutorManager)registry.callService(PortalExecutorManager.class, Function.identity());
        }
    }
}

